/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.eds.constants;

import at.itsv.eds.constants.DeliveryType;

public final class DeliveryIDTypeUnit
extends Enum<DeliveryIDTypeUnit> {
    public static final /* enum */ DeliveryIDTypeUnit SVNR = new DeliveryIDTypeUnit("svnr");
    public static final /* enum */ DeliveryIDTypeUnit DGNR = new DeliveryIDTypeUnit("dgnr");
    public static final /* enum */ DeliveryIDTypeUnit BPK = new DeliveryIDTypeUnit("bPk");
    public static final /* enum */ DeliveryIDTypeUnit UBPK = new DeliveryIDTypeUnit("ubPk");
    public static final /* enum */ DeliveryIDTypeUnit FN = new DeliveryIDTypeUnit("fn");
    public static final /* enum */ DeliveryIDTypeUnit ZVR = new DeliveryIDTypeUnit("zvr");
    public static final /* enum */ DeliveryIDTypeUnit ERSB = new DeliveryIDTypeUnit("ErsB");
    public static final /* enum */ DeliveryIDTypeUnit VPNR = new DeliveryIDTypeUnit("vpnr");
    public static final /* enum */ DeliveryIDTypeUnit KUR = new DeliveryIDTypeUnit("kur");
    public static final /* enum */ DeliveryIDTypeUnit MSBKS = new DeliveryIDTypeUnit("msbks");
    public static final /* enum */ DeliveryIDTypeUnit MSBKH = new DeliveryIDTypeUnit("msbkh");
    public static final /* enum */ DeliveryIDTypeUnit EMAIL = new DeliveryIDTypeUnit("email");
    public static final /* enum */ DeliveryIDTypeUnit TEL = new DeliveryIDTypeUnit("tel");
    private String idTypeName;
    private static final /* synthetic */ DeliveryIDTypeUnit[] $VALUES;

    public static DeliveryIDTypeUnit[] values() {
        return (DeliveryIDTypeUnit[])$VALUES.clone();
    }

    public static DeliveryIDTypeUnit valueOf(String name) {
        return Enum.valueOf(DeliveryIDTypeUnit.class, name);
    }

    private DeliveryIDTypeUnit(String idTypeName) {
        this.idTypeName = idTypeName;
    }

    public String getIDTypeName() {
        return this.idTypeName;
    }

    public String getPersonType() {
        String personType = "N";
        switch (this.idTypeName) {
            case "svnr": 
            case "bPk": 
            case "ubPk": 
            case "email": 
            case "tel": {
                personType = "N";
                break;
            }
            case "dgnr": 
            case "cmpy": 
            case "fn": 
            case "zvr": 
            case "ErsB": 
            case "vpnr": 
            case "kur": 
            case "msbks": 
            case "msbkh": {
                personType = "J";
                break;
            }
            default: {
                assert (false) : "FATAL: programming error";
                break;
            }
        }
        return personType;
    }

    public static DeliveryIDTypeUnit checkValidDeliveryIDType(String idType) {
        for (DeliveryIDTypeUnit unit : DeliveryIDTypeUnit.values()) {
            if (!unit.idTypeName.equalsIgnoreCase(idType)) continue;
            return unit;
        }
        return null;
    }

    public static DeliveryIDTypeUnit checkValidDeliveryIDType(DeliveryType deliveryType, String idType) {
        if (idType != null) {
            switch (deliveryType) {
                case BEHOERDLICH: 
                case PRIVAT: {
                    if (idType.equalsIgnoreCase(DeliveryIDTypeUnit.SVNR.idTypeName)) {
                        return SVNR;
                    }
                    if (idType.equalsIgnoreCase(DeliveryIDTypeUnit.DGNR.idTypeName)) {
                        return DGNR;
                    }
                    if (idType.equalsIgnoreCase(DeliveryIDTypeUnit.BPK.idTypeName)) {
                        return BPK;
                    }
                    if (idType.equalsIgnoreCase(DeliveryIDTypeUnit.UBPK.idTypeName)) {
                        return UBPK;
                    }
                    if (idType.equalsIgnoreCase(DeliveryIDTypeUnit.FN.idTypeName)) {
                        return FN;
                    }
                    if (idType.equalsIgnoreCase(DeliveryIDTypeUnit.ZVR.idTypeName)) {
                        return ZVR;
                    }
                    if (idType.equalsIgnoreCase(DeliveryIDTypeUnit.ERSB.idTypeName)) {
                        return ERSB;
                    }
                    if (idType.equalsIgnoreCase(DeliveryIDTypeUnit.VPNR.idTypeName)) {
                        return VPNR;
                    }
                    if (idType.equalsIgnoreCase(DeliveryIDTypeUnit.KUR.idTypeName)) {
                        return KUR;
                    }
                    if (idType.equalsIgnoreCase(DeliveryIDTypeUnit.MSBKS.idTypeName)) {
                        return MSBKS;
                    }
                    if (idType.equalsIgnoreCase(DeliveryIDTypeUnit.MSBKH.idTypeName)) {
                        return MSBKH;
                    }
                    return null;
                }
                case EMAIL: {
                    if (idType.equalsIgnoreCase(DeliveryIDTypeUnit.EMAIL.idTypeName)) {
                        return EMAIL;
                    }
                    return null;
                }
                case SMS: {
                    if (idType.equalsIgnoreCase(DeliveryIDTypeUnit.TEL.idTypeName)) {
                        return TEL;
                    }
                    return null;
                }
            }
            assert (false);
            return null;
        }
        return null;
    }

    public String toString() {
        return this.name() + "(" + this.idTypeName + ")";
    }

    static {
        $VALUES = new DeliveryIDTypeUnit[]{SVNR, DGNR, BPK, UBPK, FN, ZVR, ERSB, VPNR, KUR, MSBKS, MSBKH, EMAIL, TEL};
    }
}

