/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.eds.constants;

import at.itsv.eds.constants.DeliveryIDTypeUnit;
import at.itsv.eds.constants.DeliveryType;
import java.util.ArrayList;
import java.util.Arrays;

public enum DeliveryQuality {
    intern("intern"),
    Information("Information"),
    ConfirmReceipt("ConfirmReceipt"),
    ConfirmReceipt_plus("ConfirmReceipt+"),
    RegisteredMail("RegisteredMail"),
    RegisteredMail_plus("RegisteredMail+"),
    nonRSa("nonRSa"),
    nonRSa_plus("nonRSa+"),
    RSa("RSa"),
    RSa_plus("RSa+");

    private String typeName;

    private DeliveryQuality(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static final DeliveryQuality getQuality(String quality) {
        for (DeliveryQuality q : DeliveryQuality.values()) {
            if (!q.getTypeName().equalsIgnoreCase(quality)) continue;
            return q;
        }
        return null;
    }

    public static final DeliveryQuality[] getValidQualities(DeliveryType deliveryType) {
        DeliveryQuality[] all = DeliveryQuality.values();
        ArrayList<DeliveryQuality> q = new ArrayList<DeliveryQuality>(all.length);
        q.addAll(Arrays.asList(all));
        switch (deliveryType) {
            case BEHOERDLICH: {
                q.remove((Object)intern);
                return q.toArray(new DeliveryQuality[q.size()]);
            }
            case PRIVAT: {
                q.remove((Object)RSa);
                q.remove((Object)RSa_plus);
                return q.toArray(new DeliveryQuality[q.size()]);
            }
        }
        return null;
    }

    public static final boolean isQualityValidForPerson(DeliveryType deliveryType, DeliveryQuality quality, DeliveryIDTypeUnit idType) {
        switch (idType) {
            case SVNR: 
            case BPK: 
            case UBPK: {
                return DeliveryQuality.isQualityValidForNaturalPerson(deliveryType, quality);
            }
        }
        return DeliveryQuality.isQualityValidForLegalPerson(deliveryType, quality);
    }

    private static final boolean isQualityValidForNaturalPerson(DeliveryType deliveryType, DeliveryQuality quality) {
        if (deliveryType == DeliveryType.PRIVAT) {
            switch (quality) {
                case RSa: 
                case RSa_plus: {
                    return false;
                }
            }
            return true;
        }
        if (deliveryType == DeliveryType.BEHOERDLICH) {
            switch (quality) {
                case intern: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    private static final boolean isQualityValidForLegalPerson(DeliveryType deliveryType, DeliveryQuality quality) {
        switch (quality) {
            case RSa_plus: 
            case nonRSa_plus: 
            case ConfirmReceipt_plus: 
            case RegisteredMail_plus: {
                return false;
            }
            case intern: {
                return deliveryType == DeliveryType.PRIVAT;
            }
            case RSa: {
                return deliveryType == DeliveryType.BEHOERDLICH;
            }
        }
        return true;
    }

    public static final DeliveryQuality isQualityValid(DeliveryType deliveryType, String quality) {
        if (quality != null) {
            switch (deliveryType) {
                case BEHOERDLICH: {
                    if (quality.equalsIgnoreCase(DeliveryQuality.RSa.typeName)) {
                        return RSa;
                    }
                    if (quality.equalsIgnoreCase(DeliveryQuality.RSa_plus.typeName)) {
                        return RSa_plus;
                    }
                }
                case PRIVAT: {
                    if (quality.equalsIgnoreCase(DeliveryQuality.nonRSa.typeName)) {
                        return nonRSa;
                    }
                    if (quality.equalsIgnoreCase(DeliveryQuality.nonRSa_plus.typeName)) {
                        return nonRSa_plus;
                    }
                    if (quality.equalsIgnoreCase(DeliveryQuality.intern.typeName)) {
                        if (deliveryType == DeliveryType.BEHOERDLICH) {
                            return null;
                        }
                        return intern;
                    }
                    if (quality.equalsIgnoreCase(DeliveryQuality.Information.typeName)) {
                        return Information;
                    }
                    if (quality.equalsIgnoreCase(DeliveryQuality.ConfirmReceipt.typeName)) {
                        return ConfirmReceipt;
                    }
                    if (quality.equalsIgnoreCase(DeliveryQuality.ConfirmReceipt_plus.typeName)) {
                        return ConfirmReceipt_plus;
                    }
                    if (quality.equalsIgnoreCase(DeliveryQuality.RegisteredMail.typeName)) {
                        return RegisteredMail;
                    }
                    if (quality.equalsIgnoreCase(DeliveryQuality.RegisteredMail_plus.typeName)) {
                        return RegisteredMail_plus;
                    }
                    return null;
                }
                case EMAIL: 
                case SMS: {
                    return nonRSa;
                }
            }
            return null;
        }
        return null;
    }

    public String toString() {
        return this.typeName;
    }
}

