/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.eds.constants;

import java.util.HashSet;
import java.util.Set;

public enum DeliveryType {
    BEHOERDLICH("beh\u00f6rdlich"),
    PRIVAT("privat"),
    EMAIL("email"),
    SMS("sms");

    private String typeName;

    private DeliveryType(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static DeliveryType checkValidDeliveryType(String type) {
        if (type != null) {
            for (DeliveryType deliveryTypeUnit : DeliveryType.values()) {
                if (!type.equalsIgnoreCase(deliveryTypeUnit.typeName)) continue;
                return deliveryTypeUnit;
            }
        }
        return null;
    }

    public static Set<DeliveryType> deliveryTypes(String deliveryTypes) {
        if (deliveryTypes == null || deliveryTypes.trim().length() == 0) {
            return null;
        }
        String[] types = deliveryTypes.split("\\|");
        HashSet<DeliveryType> dTypes = new HashSet<DeliveryType>(types.length);
        for (String type : types) {
            DeliveryType dType = DeliveryType.checkValidDeliveryType(type);
            if (dType == null) continue;
            dTypes.add(dType);
        }
        return dTypes;
    }

    public String toString() {
        return this.name() + "(" + this.typeName + ")";
    }
}

