/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.poslib.soap.utils.client;

import at.itsv.poslib.simple.utils.exception.PoslibRuntimeException;
import at.itsv.poslib.simple.utils.x509.X509TrustManagerWrapper;
import at.itsv.poslib.soap.utils.client.ISoapProxyPort;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.apache.wss4j.common.ext.WSPasswordCallback;

final class CXFSoapProxyPort
implements ISoapProxyPort {
    private static final String CXF_PROP_ACTION = "action";
    private static final String CXF_PROP_PWD_TYPE = "passwordType";
    private static final String CXF_PROP_USER = "user";
    private static final String CXF_PROP_PWD_CALLBACK = "passwordCallbackRef";
    private static final String CXF_VAL_ACTION = "UsernameToken";
    private static final String CXF_VAL_PWD_TYPE = "PasswordDigest";
    private static final String HTTP_CLIENT_STREAMING_CHUNK_SIZE = "com.sun.xml.internal.ws.transport.http.client.streaming.chunk.size";

    private CXFSoapProxyPort() {
    }

    public static CXFSoapProxyPort create() {
        return new CXFSoapProxyPort();
    }

    @Override
    public final <T> T createPort(Class<T> serviceClass) {
        return this.createPort(serviceClass, null);
    }

    @Override
    public final <T> T createPort(Class<T> serviceClass, ISoapProxyPort.SoapProxyConfig config) {
        return this.createPort(serviceClass, config, null);
    }

    @Override
    public final <T> T createPort(Class<T> serviceClass, ISoapProxyPort.SoapProxyConfig config, String soapVersion) {
        T proxy;
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(serviceClass);
        if (soapVersion != null) {
            factory.setBindingId(soapVersion);
        }
        if (config != null) {
            if (config.getEndpoint() != null) {
                factory.setAddress(config.getEndpoint());
            }
            if (config.getWsdlLocation() != null) {
                factory.setWsdlLocation(config.getWsdlLocation().toString());
            }
            proxy = CXFSoapProxyPort.create(factory);
            proxy = this.setupPort(proxy, config);
        } else {
            proxy = CXFSoapProxyPort.create(factory);
        }
        return proxy;
    }

    @Override
    public <T> void setSoapHeaders(T proxy, Map<String, String> headers) {
        this.setSoapHeaders(proxy, "at.itsv.poslib", headers);
    }

    @Override
    public <T> void setSoapHeaders(T proxy, String namespaceURI, Map<String, String> headers) {
        assert (proxy instanceof BindingProvider);
        assert (headers != null);
        BindingProvider port = (BindingProvider)proxy;
        try {
            ArrayList<Header> result = new ArrayList<Header>();
            JAXBDataBinding bind = new JAXBDataBinding(new Class[]{String.class});
            for (Map.Entry<String, String> e : headers.entrySet()) {
                result.add(new Header(new QName(namespaceURI, e.getKey()), (Object)e.getValue(), (DataBinding)bind));
            }
            port.getRequestContext().put(Header.HEADER_LIST, result);
        }
        catch (JAXBException e) {
            throw new PoslibRuntimeException((Throwable)e);
        }
    }

    @Override
    public <T> void addSoapHeader(T proxy, String localPart, String value) {
        this.addSoapHeader(proxy, "at.itsv.poslib", localPart, value);
    }

    @Override
    public <T> void addSoapHeader(T proxy, String namespaceURI, String localPart, String value) {
        this.addSoapHeader(proxy, new QName(namespaceURI, localPart), value);
    }

    @Override
    public <T> void addSoapHeader(T proxy, QName qname, String value) {
        assert (proxy instanceof BindingProvider);
        BindingProvider port = (BindingProvider)proxy;
        ArrayList<Header> headers = CastUtils.cast((List)((List)port.getRequestContext().get(Header.HEADER_LIST)));
        try {
            if (headers == null) {
                headers = new ArrayList<Header>();
                headers.add(new Header(qname, (Object)value, (DataBinding)new JAXBDataBinding(new Class[]{String.class})));
                port.getRequestContext().put(Header.HEADER_LIST, headers);
                return;
            }
            for (Header header : headers) {
                if (!qname.equals(header.getName())) continue;
                header.setObject((Object)value);
                return;
            }
            headers.add(new Header(qname, (Object)value, (DataBinding)new JAXBDataBinding(new Class[]{String.class})));
        }
        catch (JAXBException e) {
            throw new PoslibRuntimeException((Throwable)e);
        }
    }

    private static final <T> T create(JaxWsProxyFactoryBean factory) {
        return (T)factory.create();
    }

    private static void setupTimeouts(ISoapProxyPort.SoapProxyConfig config, HTTPClientPolicy policy) {
        if (config.getConnectionTimeout() != null) {
            policy.setConnectionTimeout(config.getConnectionTimeout().longValue());
        }
        if (config.getReceiveTimeout() != null) {
            policy.setReceiveTimeout(config.getReceiveTimeout().longValue());
        }
    }

    private static WSS4JOutInterceptor setupWSSecMTOMChunking(BindingProvider port, ISoapProxyPort.SoapProxyConfig config, Map<String, Object> outProps, HTTPClientPolicy policy) {
        if (config.isUseMtom() || config.getHttpChunkSize() != null) {
            policy.setAllowChunking(true);
            int chunkSize = config.getHttpChunkSize() == null ? 8192 : config.getHttpChunkSize();
            port.getRequestContext().put(HTTP_CLIENT_STREAMING_CHUNK_SIZE, chunkSize);
            policy.setChunkLength(chunkSize);
        }
        if (config.getHttpChunkThreshold() != null) {
            policy.setChunkingThreshold(config.getHttpChunkThreshold().intValue());
        }
        MyWSS4JOutInterceptor out = new MyWSS4JOutInterceptor(outProps, config.isUseMtom());
        if (config.isUseMtom()) {
            SOAPBinding binding = (SOAPBinding)port.getBinding();
            binding.setMTOMEnabled(true);
            out.setAllowMTOM(true);
        }
        return out;
    }

    @Override
    public final <T> T setupPort(T proxy, ISoapProxyPort.SoapProxyConfig config) {
        assert (config != null);
        assert (proxy != null);
        assert (proxy instanceof BindingProvider);
        BindingProvider port = (BindingProvider)proxy;
        if (config.getEndpoint() != null) {
            port.getRequestContext().put("javax.xml.ws.service.endpoint.address", config.getEndpoint());
        }
        if (config.isUseSchemaValidation()) {
            port.getRequestContext().put("schema-validation-enabled", Boolean.TRUE);
        }
        HashMap<String, Object> outProps = new HashMap<String, Object>();
        if (config.getUser() != null) {
            outProps.put(CXF_PROP_ACTION, CXF_VAL_ACTION);
            outProps.put(CXF_PROP_PWD_TYPE, CXF_VAL_PWD_TYPE);
            outProps.put(CXF_PROP_USER, config.getUser());
            outProps.put(CXF_PROP_PWD_CALLBACK, new MyCallbackHandler(config.getPass()));
        }
        Client client = ClientProxy.getClient((Object)port);
        HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
        HTTPClientPolicy policy = httpConduit.getClient();
        CXFSoapProxyPort.setupTimeouts(config, policy);
        WSS4JOutInterceptor out = CXFSoapProxyPort.setupWSSecMTOMChunking(port, config, outProps, policy);
        if (config.isUseTLS()) {
            httpConduit.setTlsClientParameters(CXFSoapProxyPort.getTLSClientParams(config));
        }
        if (config.getUser() != null) {
            client.getOutInterceptors().add(out);
        }
        return proxy;
    }

    private static final TrustManager[] wrapTrustManagers(TrustManager[] tm) {
        TrustManager[] wrapped = new TrustManager[tm.length];
        for (int i = 0; i < tm.length; ++i) {
            wrapped[i] = tm[i] instanceof X509TrustManager ? new X509TrustManagerWrapper((X509TrustManager)tm[i]) : tm[i];
        }
        return wrapped;
    }

    private static final TLSClientParameters getTLSClientParams(ISoapProxyPort.SoapProxyConfig config) {
        try {
            TLSClientParameters tlsParams = new TLSClientParameters();
            tlsParams.setUseHttpsURLConnectionDefaultHostnameVerifier(false);
            tlsParams.setUseHttpsURLConnectionDefaultSslSocketFactory(false);
            KeyStore rootca = KeyStore.getInstance(config.getTrustStoreType());
            rootca.load(config.getTrustStoreContent(), config.getTrustStorePass());
            KeyStore mycert = KeyStore.getInstance(config.getKeyStoreType());
            mycert.load(config.getKeyStoreContent(), config.getKeyStorePass());
            tlsParams.setDisableCNCheck(config.isDisableCNCheck());
            tlsParams.setSecureSocketProtocol("TLS");
            TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustFactory.init(rootca);
            TrustManager[] tm = trustFactory.getTrustManagers();
            if (config.isUseTrustManagerWrapper()) {
                tlsParams.setTrustManagers(CXFSoapProxyPort.wrapTrustManagers(tm));
            } else {
                tlsParams.setTrustManagers(tm);
            }
            KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyFactory.init(mycert, config.getKeyStorePass());
            KeyManager[] km = keyFactory.getKeyManagers();
            tlsParams.setKeyManagers(km);
            return tlsParams;
        }
        catch (Exception e) {
            throw new PoslibRuntimeException("FATAL: could not setup CXF-TLS", (Throwable)e);
        }
    }

    private static final class MyWSS4JOutInterceptor
    extends WSS4JOutInterceptor {
        private final boolean useMtom;

        MyWSS4JOutInterceptor(Map<String, Object> outProps, boolean useMtom) {
            super(outProps);
            this.useMtom = useMtom;
        }

        public void handleMessage(SoapMessage mc) {
            if (this.useMtom) {
                mc.put("mtom-enabled", (Object)Boolean.TRUE);
            }
            super.handleMessage(mc);
        }

        public void setAllowMTOM(boolean allowMTOM) {
            super.setAllowMTOM(allowMTOM);
        }
    }

    private static final class MyCallbackHandler
    implements CallbackHandler {
        private final String password;

        MyCallbackHandler(String password) {
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            assert (callbacks != null && callbacks.length != 0);
            for (int i = 0; i < callbacks.length; ++i) {
                if (!(callbacks[i] instanceof WSPasswordCallback)) continue;
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                pc.setPassword(this.password);
                return;
            }
            throw new UnsupportedCallbackException(callbacks[0]);
        }
    }
}

