/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.poslib.soap.utils.client;

import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.xml.namespace.QName;

public interface ISoapProxyPort {
    public static final String SOAP_12 = "http://schemas.xmlsoap.org/wsdl/soap12/";

    default public SoapProxyConfig createConfig() {
        return new SoapProxyConfig();
    }

    public <T> T createPort(Class<T> var1);

    public <T> T createPort(Class<T> var1, SoapProxyConfig var2);

    public <T> T createPort(Class<T> var1, SoapProxyConfig var2, String var3);

    public <T> T setupPort(T var1, SoapProxyConfig var2);

    public <T> void setSoapHeaders(T var1, Map<String, String> var2);

    public <T> void setSoapHeaders(T var1, String var2, Map<String, String> var3);

    public <T> void addSoapHeader(T var1, String var2, String var3);

    public <T> void addSoapHeader(T var1, String var2, String var3, String var4);

    public <T> void addSoapHeader(T var1, QName var2, String var3);

    public static class SoapProxyConfig {
        private boolean useTLS;
        private boolean disableCNCheck;
        private boolean useTrustManagerWrapper;
        private String trustStoreType;
        private InputStream trustStoreContent;
        private char[] trustStorePass;
        private String keyStoreType;
        private InputStream keyStoreContent;
        private char[] keyStorePass;
        private String endpoint;
        private String user;
        private String pass;
        private URL wsdlLocation;
        private boolean useMtom;
        private Integer httpChunkSize;
        private Integer httpChunkThreshold;
        private Long receiveTimeout;
        private Long connectionTimeout;
        private boolean useSchemaValidation;

        private SoapProxyConfig() {
        }

        public SoapProxyConfig setUseSchemaValidation(boolean useSchemaValidation) {
            this.useSchemaValidation = useSchemaValidation;
            return this;
        }

        public SoapProxyConfig setUseTLS(boolean useTLS) {
            this.useTLS = useTLS;
            return this;
        }

        public SoapProxyConfig setDisableCNCheck(boolean disableCNCheck) {
            this.disableCNCheck = disableCNCheck;
            return this;
        }

        public SoapProxyConfig setUseTrustManagerWrapper(boolean useTrustManagerWrapper) {
            this.useTrustManagerWrapper = useTrustManagerWrapper;
            return this;
        }

        public SoapProxyConfig setTrustStore(String trustStoreType, InputStream trustStoreContent, String trustStorePass) {
            this.trustStoreType = trustStoreType;
            this.trustStoreContent = trustStoreContent;
            this.trustStorePass = trustStorePass.toCharArray();
            return this;
        }

        public SoapProxyConfig setKeyStore(String keyStoreType, InputStream keyStoreContent, String keyStorePass) {
            this.keyStoreType = keyStoreType;
            this.keyStoreContent = keyStoreContent;
            this.keyStorePass = keyStorePass.toCharArray();
            return this;
        }

        public SoapProxyConfig setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public SoapProxyConfig setUser(String user) {
            this.user = user;
            return this;
        }

        public SoapProxyConfig setPass(String pass) {
            this.pass = pass;
            return this;
        }

        public SoapProxyConfig setWsdlLocation(URL wsdlLocation) {
            this.wsdlLocation = wsdlLocation;
            return this;
        }

        public SoapProxyConfig setUseMtom(boolean useMtom) {
            this.useMtom = useMtom;
            return this;
        }

        public SoapProxyConfig setHttpChunkSize(int httpChunkSize) {
            this.httpChunkSize = httpChunkSize;
            return this;
        }

        public SoapProxyConfig setHttpChunkThreshold(int httpChunkThreshold) {
            this.httpChunkThreshold = httpChunkThreshold;
            return this;
        }

        public SoapProxyConfig setReceiveTimeout(long receiveTimeout) {
            this.receiveTimeout = receiveTimeout;
            return this;
        }

        public SoapProxyConfig setConnectionTimeout(long connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public boolean isUseTLS() {
            return this.useTLS;
        }

        public boolean isDisableCNCheck() {
            return this.disableCNCheck;
        }

        public boolean isUseTrustManagerWrapper() {
            return this.useTrustManagerWrapper;
        }

        public String getTrustStoreType() {
            return this.trustStoreType;
        }

        public InputStream getTrustStoreContent() {
            return this.trustStoreContent;
        }

        public char[] getTrustStorePass() {
            return this.trustStorePass;
        }

        public String getKeyStoreType() {
            return this.keyStoreType;
        }

        public InputStream getKeyStoreContent() {
            return this.keyStoreContent;
        }

        public char[] getKeyStorePass() {
            return this.keyStorePass;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getUser() {
            return this.user;
        }

        public String getPass() {
            return this.pass;
        }

        public URL getWsdlLocation() {
            return this.wsdlLocation;
        }

        public boolean isUseMtom() {
            return this.useMtom;
        }

        public Integer getHttpChunkSize() {
            return this.httpChunkSize;
        }

        public Integer getHttpChunkThreshold() {
            return this.httpChunkThreshold;
        }

        public Long getReceiveTimeout() {
            return this.receiveTimeout;
        }

        public Long getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public boolean isUseSchemaValidation() {
            return this.useSchemaValidation;
        }
    }
}

