/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.poslib.soap.utils.service;

import at.itsv.poslib.soap.utils.SoapConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBinding;

public class CXFPoslibSoapHeaderInterceptor
extends AbstractSoapInterceptor {
    public CXFPoslibSoapHeaderInterceptor() {
        super("unmarshal");
    }

    public void handleMessage(SoapMessage message) {
        List headers = message.getHeaders();
        if (headers == null) {
            ArrayList<Header> nheaders = new ArrayList<Header>(1);
            nheaders.add(CXFPoslibSoapHeaderInterceptor.createTransactionIDHeader());
            message.put(Header.HEADER_LIST, nheaders);
            return;
        }
        Iterator it = headers.iterator();
        boolean hasTransactionID = false;
        while (it.hasNext()) {
            Header e = (Header)it.next();
            if (!SoapConstants.POSLIB_TRANSACTION_ID_QNAME.equals(e.getName())) continue;
            hasTransactionID = true;
            break;
        }
        if (!hasTransactionID) {
            headers.add(CXFPoslibSoapHeaderInterceptor.createTransactionIDHeader());
        }
    }

    private static final Header createTransactionIDHeader() {
        try {
            SoapHeader header = new SoapHeader(SoapConstants.POSLIB_TRANSACTION_ID_QNAME, (Object)SoapConstants.generateTransactionID(), (DataBinding)new JAXBDataBinding(new Class[]{String.class}));
            header.setDirection(Header.Direction.DIRECTION_IN);
            return header;
        }
        catch (JAXBException e) {
            throw new Fault((Throwable)e);
        }
    }
}

