/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.security.servicesecurity.client;

import at.itsv.security.servicesecurity.soap.SecuredServiceOutInterceptor;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;

public final class SecuredServiceClient {
    private final String username;
    private final String password;
    private final Object service;
    private boolean withTimestamp;

    private SecuredServiceClient(Object service, String username, String password, boolean withTimestamp) {
        if (service == null) {
            throw new IllegalArgumentException("service darf nicht null sein");
        }
        this.service = service;
        this.username = username;
        this.password = password;
        this.withTimestamp = withTimestamp;
    }

    public static SecuredServiceClient createForService(Object service) {
        return new SecuredServiceClient(service, null, null, false);
    }

    public SecuredServiceClient withCredentials(String username, String password) {
        if (username == null || password == null) {
            throw new IllegalArgumentException("username oder password ist null");
        }
        return new SecuredServiceClient(this.service, username, password, this.withTimestamp);
    }

    public SecuredServiceClient withTimestamp() {
        return new SecuredServiceClient(this.service, this.username, this.password, true);
    }

    public void apply() {
        if (this.username == null || this.password == null) {
            throw new IllegalStateException("username oder password ist null");
        }
        Client cl = ClientProxy.getClient((Object)this.service);
        cl.getEndpoint().getOutInterceptors().add(new SecuredServiceOutInterceptor(this.username, this.password, this.withTimestamp));
    }
}

