/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.security.servicesecurity.soap;

import at.itsv.security.servicesecurity.soap.PasswordHandler;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;

public final class SecuredServiceOutInterceptor
extends AbstractSoapInterceptor {
    private final Map<String, Object> outProps = new HashMap<String, Object>(16);

    public SecuredServiceOutInterceptor(String username, String password) {
        this("pre-protocol", username, password, false);
    }

    public SecuredServiceOutInterceptor(String username, String password, boolean withTimestamp) {
        this("pre-protocol", username, password, withTimestamp);
    }

    public SecuredServiceOutInterceptor(String phase, String username, String password, boolean withTimestamp) {
        super(phase);
        StringBuilder action = new StringBuilder("Timestamp".length() + "UsernameToken".length() + 2);
        if (withTimestamp) {
            action.append("Timestamp").append(' ');
        }
        action.append("UsernameToken");
        this.outProps.put("action", action.toString());
        this.outProps.put("user", username);
        this.outProps.put("passwordCallbackRef", new PasswordHandler(password));
    }

    public void handleMessage(SoapMessage message) {
        WSS4JOutInterceptor wss4j = new WSS4JOutInterceptor(new HashMap<String, Object>(this.outProps));
        wss4j.setPhase(this.getPhase());
        message.getInterceptorChain().add((Interceptor)wss4j);
    }
}

