/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.security.webservice;

import at.itsv.commons.config.keyvalue.KeyValueConfiguration;
import at.itsv.commons.config.keyvalue.KeyValueConfigurationBuilder;
import at.itsv.security.servicesecurity.passwordprovider.PasswordProvider;
import at.itsv.security.servicesecurity.passwordprovider.PasswordProviderBuilder;
import at.itsv.security.webservice.WSSecurityConfig;
import at.itsv.security.webservice.WSSecurityException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWSSecurityInterceptor
extends AbstractSoapInterceptor {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractWSSecurityInterceptor.class);
    private boolean useJndi = true;
    private String configurationPath;
    private String passwordPath;
    private KeyValueConfiguration configuration;
    private PasswordProvider passwordProvider;

    AbstractWSSecurityInterceptor() {
        this(null, null);
    }

    AbstractWSSecurityInterceptor(String configurationPath, String passwordPath) {
        this(configurationPath, passwordPath, true);
    }

    AbstractWSSecurityInterceptor(String configurationPath, String passwordPath, boolean useJndi) {
        this("pre-protocol", configurationPath, passwordPath, useJndi);
    }

    AbstractWSSecurityInterceptor(String p, String configurationPath, String passwordPath, boolean useJndi) {
        super(p);
        this.configurationPath = configurationPath;
        this.passwordPath = passwordPath;
        this.useJndi = useJndi;
    }

    protected KeyValueConfiguration configuration() {
        return this.configuration;
    }

    protected PasswordProvider passwordProvider() {
        return this.passwordProvider;
    }

    public void handleMessage(SoapMessage message) throws Fault {
        SoapVersion version = message.getVersion();
        try {
            if (this.configuration == null) {
                this.loadConfiguration(message);
            }
            if (this.isSecurityEnabled()) {
                HashMap<String, Object> outProps = new HashMap<String, Object>();
                StringBuilder action = new StringBuilder();
                if (this.isTimestampEnabled()) {
                    action.append("Timestamp ");
                }
                action.append("UsernameToken");
                outProps.put("action", action.toString());
                if (this.getTimeToLiveSeconds() != null) {
                    outProps.put("timeToLive", this.getTimeToLiveSeconds());
                    outProps.put("timestampStrict", Boolean.TRUE.toString());
                }
                this.handleSecureMessageInternal(message, outProps);
            }
        }
        catch (WSSecurityException e) {
            throw new SoapFault("Error on intercepting webservice for security issues ", (Throwable)e, version.getSender());
        }
    }

    protected abstract void handleSecureMessageInternal(SoapMessage var1, Map<String, Object> var2) throws WSSecurityException;

    protected abstract boolean loadPasswords();

    private WSSecurityConfig getWSecurityConfig(Class<?> serviceImplementation) {
        for (Annotation annotation : serviceImplementation.getAnnotations()) {
            if (!(annotation instanceof WSSecurityConfig)) continue;
            return (WSSecurityConfig)annotation;
        }
        return null;
    }

    private boolean isSecurityEnabled() {
        return this.configuration.booleanValueOf("SECURITY_ENABLED", true);
    }

    private boolean isTimestampEnabled() {
        return this.configuration.booleanValueOf("TIMESTAMP_ENABLED", true);
    }

    private String getTimeToLiveSeconds() {
        return this.configuration.valueOf("TIME_TO_LIVE_SECONDS", null);
    }

    private synchronized void loadConfiguration(SoapMessage message) throws WSSecurityException {
        if (this.configuration != null) {
            return;
        }
        LOG.info("Start: Reading configurations for Webservice ");
        Class serviceImplementation = (Class)((Service)message.getExchange().get(Service.class)).get((Object)"endpoint.class");
        String loggingPart = "for Webservice of Class " + serviceImplementation.getSimpleName();
        LOG.info("Reading configurations " + loggingPart);
        if (this.configurationPath == null) {
            WSSecurityConfig config = this.getWSecurityConfig(serviceImplementation);
            if (config == null) {
                LOG.error("Wrong configuration for Webservice-Security : Configuration missing " + loggingPart);
                throw new WSSecurityException("Missing configuration for Webservice-Security on server side");
            }
            this.configurationPath = config.configurationPath();
            this.passwordPath = config.passwordPath();
            this.useJndi = !config.useFilePath();
        }
        LOG.info("Using configuration-path " + this.configurationPath + " " + loggingPart);
        this.configuration = this.createConfiguration(this.configurationPath);
        if (this.isSecurityEnabled() && this.loadPasswords()) {
            if (this.passwordPath == null) {
                LOG.error("No password path configured for Webservice-Security " + loggingPart);
                throw new WSSecurityException("Wrong configuration for Webservice-Security on server side - password configuration is missing");
            }
            LOG.info("Using password-path " + this.passwordPath + " " + loggingPart);
            this.passwordProvider = PasswordProviderBuilder.fromKeyValueConfiguration((KeyValueConfiguration)this.createConfiguration(this.passwordPath), null).build();
        }
    }

    private KeyValueConfiguration createConfiguration(String path) throws WSSecurityException {
        try {
            return this.useJndi ? KeyValueConfigurationBuilder.fromJndi().withCheckedPrefix("java:global/" + path + '/').build() : KeyValueConfigurationBuilder.fromJBossPropertiesResource((String)path).build();
        }
        catch (IllegalArgumentException ex) {
            throw new WSSecurityException("Error on loading configuration", ex);
        }
        catch (NamingException ex) {
            throw new WSSecurityException("Error on initializing WS-security configuration. Couldn't create JNDI-Context.", ex);
        }
        catch (IOException ex) {
            throw new WSSecurityException("Error on loading configuration from file " + path, ex);
        }
    }
}

