/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.security.webservice;

import at.itsv.commons.config.keyvalue.KeyValueConfiguration;
import at.itsv.security.webservice.PasswordTokenCreator;
import at.itsv.security.webservice.WSSecurityException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.util.StringUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractXMLSignatureCreator
implements PasswordTokenCreator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractXMLSignatureCreator.class);

    @Override
    public String createPasswordToken(Document xmlDocument, KeyValueConfiguration configuration, String password) throws WSSecurityException {
        List<SignaturePart> signatureParts;
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)xmlDocument.getDocumentElement());
        String rawSignatureParts = configuration.valueOf("SIGNATURE_PARTS", "");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsing configured signature parts " + rawSignatureParts);
        }
        if ((signatureParts = this.parseSignatureParts(rawSignatureParts, soapConstants.getEnvelopeURI())).isEmpty()) {
            signatureParts.add(new SignaturePart(soapConstants.getEnvelopeURI(), soapConstants.getBodyQName().getLocalPart()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching elements for signature in XML : " + rawSignatureParts);
        }
        ArrayList<Element> elementsForSignature = new ArrayList<Element>();
        for (SignaturePart signaturePart : signatureParts) {
            Element found = this.findElement(xmlDocument, signaturePart);
            if (found == null) {
                throw new WSSecurityException("Cannot find element " + signaturePart.getElementName() + " (Namespace " + signaturePart.getNamespace() + " ) needed for creating signature");
            }
            elementsForSignature.add(found);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating XML-signature for signature in XML : " + rawSignatureParts);
        }
        try {
            byte[] signatureValue = this.createXMLSignatureValue(xmlDocument, elementsForSignature, password);
            String passwordToken = Base64.encode((byte[])signatureValue);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created (Base64 encoded) XML signature " + passwordToken + " with password " + password + " for XML-Parts: " + rawSignatureParts);
            }
            return passwordToken;
        }
        catch (Exception e) {
            throw new WSSecurityException("Error on creating signature: " + e.getMessage(), e);
        }
    }

    protected String createElementId(Element element) {
        String id = element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (id == null || id.length() == 0) {
            id = "id-" + Integer.toString(element.hashCode());
            String prefix = WSSecurityUtil.setNamespace((Element)element, (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", (String)"wsu");
            element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", prefix + ":Id", id);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get or created ID for XML-element " + element.getNodeName() + " : " + id);
        }
        return id;
    }

    protected abstract byte[] createXMLSignatureValue(Document var1, List<Element> var2, String var3) throws Exception;

    protected Element findElement(Document xmlDocument, SignaturePart part) {
        Element envelope = xmlDocument.getDocumentElement();
        return WSSecurityUtil.findElement((Node)envelope, (String)part.getElementName(), (String)part.getNamespace());
    }

    private List<SignaturePart> parseSignatureParts(String configurationPart, String soapEnvelopURI) throws WSSecurityException {
        String[] rawParts = StringUtil.split((String)configurationPart, (char)';');
        ArrayList<SignaturePart> resultList = new ArrayList<SignaturePart>();
        for (String rawPart : rawParts) {
            SignaturePart part = null;
            String[] partDef = StringUtil.split((String)rawPart, (char)'}');
            if (partDef.length == 1) {
                part = new SignaturePart(soapEnvelopURI, partDef[0].trim());
            } else if (partDef.length == 2) {
                String nmSpace = partDef[0].trim();
                if (nmSpace.length() <= 1) {
                    nmSpace = soapEnvelopURI;
                } else if ((nmSpace = nmSpace.substring(1)).equals("Null")) {
                    nmSpace = null;
                }
                String element = partDef[1].trim();
                part = new SignaturePart(nmSpace, element);
            } else {
                throw new WSSecurityException("WSHandler: wrong part definition: " + configurationPart);
            }
            resultList.add(part);
        }
        return resultList;
    }

    protected static class SignaturePart {
        private final String elementName;
        private final String namespace;

        public SignaturePart(String namespace, String elementName) {
            this.namespace = namespace;
            this.elementName = elementName;
        }

        public String getElementName() {
            return this.elementName;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }
}

