/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.security.webservice;

import at.itsv.commons.config.keyvalue.KeyValueConfiguration;
import at.itsv.security.servicesecurity.passwordprovider.PasswordProvider;
import at.itsv.security.webservice.WSSecurityException;
import at.itsv.security.webservice.XMLSignatureHMACSha1;
import java.io.IOException;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.ws.security.WSPasswordCallback;
import org.w3c.dom.Document;

public class PasswordHandler
implements CallbackHandler {
    private final KeyValueConfiguration configuration;
    private final PasswordProvider passwordProvider;
    private final SoapMessage message;
    private final String username;
    private final String password;

    public PasswordHandler(KeyValueConfiguration configuration, PasswordProvider passwordProvider, SoapMessage message) {
        this.configuration = configuration;
        this.passwordProvider = passwordProvider;
        this.message = message;
        this.username = null;
        this.password = null;
    }

    public PasswordHandler(KeyValueConfiguration configuration, PasswordProvider passwordProvider, SoapMessage message, String username, String password) {
        this.configuration = configuration;
        this.passwordProvider = passwordProvider;
        this.message = message;
        this.username = username;
        this.password = password;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (!(callbacks[0] instanceof WSPasswordCallback)) {
            throw new UnsupportedCallbackException(callbacks[0]);
        }
        WSPasswordCallback pc = (WSPasswordCallback)callbacks[0];
        String plainPassword = this.findPassword(pc.getIdentifier());
        if (plainPassword != null) {
            try {
                String constructedPassword = this.constructMessagePassword(plainPassword);
                pc.setPassword(constructedPassword);
            }
            catch (WSSecurityException e) {
                throw new IOException("Error on creating password token for user " + pc.getIdentifier(), e);
            }
        }
    }

    private String findPassword(String username) {
        if (this.username != null && this.username.equals(username)) {
            return this.password;
        }
        Set passwords = this.passwordProvider.passwordsFor(username);
        if (passwords.size() == 1) {
            return (String)passwords.iterator().next();
        }
        if (passwords.size() > 1) {
            throw new IllegalArgumentException("Mehrere Passwoerter nicht zulaessig! Benutzer: " + username);
        }
        return null;
    }

    private String constructMessagePassword(String userPassword) throws WSSecurityException {
        SOAPMessage saaj = (SOAPMessage)this.message.getContent(SOAPMessage.class);
        SOAPPart doc = saaj.getSOAPPart();
        if (this.isSignatureEnabled()) {
            XMLSignatureHMACSha1 creator = new XMLSignatureHMACSha1();
            return creator.createPasswordToken((Document)doc, this.configuration, userPassword);
        }
        return userPassword;
    }

    private boolean isSignatureEnabled() {
        return this.configuration.booleanValueOf("SIGNATURE_ENABLED", false);
    }
}

