/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.security.webservice;

import at.itsv.security.webservice.AbstractWSSecurityInterceptor;
import at.itsv.security.webservice.PasswordHandler;
import at.itsv.security.webservice.WSSecurityException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;

public final class WSSecurityInInterceptor
extends AbstractWSSecurityInterceptor {
    public static final Set<QName> HEADERS = new HashSet<QName>();

    public WSSecurityInInterceptor() {
        this(null, null, true);
    }

    public WSSecurityInInterceptor(String p, String configurationPath, String passwordPath, boolean useJndi) {
        super(p, configurationPath, passwordPath, useJndi);
    }

    private WSSecurityInInterceptor(String configurationPath, String passwortPath, boolean useJndi) {
        super(configurationPath, passwortPath, useJndi);
    }

    public static WSSecurityInInterceptor WSSecurityInInterceptorJndi(String configurationPath, String passwordPath) {
        return new WSSecurityInInterceptor(configurationPath, passwordPath, true);
    }

    public static WSSecurityInInterceptor WSSecurityInInterceptorFile(String configurationFile, String passwordFile) {
        return new WSSecurityInInterceptor(configurationFile, passwordFile, false);
    }

    public Set<QName> getUnderstoodHeaders() {
        return HEADERS;
    }

    @Override
    protected void handleSecureMessageInternal(SoapMessage message, Map<String, Object> props) throws WSSecurityException {
        props.put("passwordCallbackRef", new PasswordHandler(this.configuration(), this.passwordProvider(), message));
        if (!this.configuration().booleanValueOf("BSP_COMPLIANCE_CHECK_ENABLED", true)) {
            props.put("isBSPCompliant", "false");
        }
        WSS4JInInterceptor wss4j = new WSS4JInInterceptor(props);
        wss4j.setPhase(this.getPhase());
        message.getInterceptorChain().add((Interceptor)wss4j);
    }

    @Override
    protected boolean loadPasswords() {
        return true;
    }

    static {
        HEADERS.add(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"));
        HEADERS.add(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "Security"));
    }
}

