/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.security.webservice;

import at.itsv.security.webservice.AbstractWSSecurityInterceptor;
import at.itsv.security.webservice.PasswordHandler;
import at.itsv.security.webservice.WSSecurityException;
import java.util.Map;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;

public final class WSSecurityOutInterceptor
extends AbstractWSSecurityInterceptor {
    private final String password;
    private final String username;

    private WSSecurityOutInterceptor(String configurationPath, boolean useJndi, String username, String password) {
        super(configurationPath, null, useJndi);
        this.username = username;
        this.password = password;
    }

    public static WSSecurityOutInterceptor WSSecurityOutInterceptorJndi(String username, String password) {
        return WSSecurityOutInterceptor.WSSecurityOutInterceptorJndi("at/itsv/security/webservices/configurations", username, password);
    }

    public static WSSecurityOutInterceptor WSSecurityOutInterceptorJndi(String configurationPath, String username, String password) {
        return new WSSecurityOutInterceptor(configurationPath, true, username, password);
    }

    public static WSSecurityOutInterceptor WSSecurityOutInterceptorFile(String username, String password) {
        return WSSecurityOutInterceptor.WSSecurityOutInterceptorFile("/sv/webservices/configuration.properties", username, password);
    }

    public static WSSecurityOutInterceptor WSSecurityOutInterceptorFile(String configurationFile, String username, String password) {
        return new WSSecurityOutInterceptor(configurationFile, false, username, password);
    }

    public WSSecurityOutInterceptor(String phase, String configurationPath, boolean useJndi, String username, String password) {
        super(phase, configurationPath, null, useJndi);
        this.username = username;
        this.password = password;
    }

    @Override
    protected void handleSecureMessageInternal(SoapMessage message, Map<String, Object> outProps) throws WSSecurityException {
        outProps.put("user", this.username);
        outProps.put("passwordCallbackRef", new PasswordHandler(this.configuration(), this.passwordProvider(), message, this.username, this.password));
        WSS4JOutInterceptor wss4j = new WSS4JOutInterceptor(outProps);
        wss4j.setPhase(this.getPhase());
        message.getInterceptorChain().add((Interceptor)wss4j);
    }

    @Override
    protected boolean loadPasswords() {
        return false;
    }
}

