/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.security.webservice;

import at.itsv.security.webservice.AbstractXMLSignatureCreator;
import at.itsv.security.webservice.WSSecurityException;
import java.io.ByteArrayOutputStream;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLSignatureHMACSha1
extends AbstractXMLSignatureCreator {
    private static Logger logger = LoggerFactory.getLogger(XMLSignatureHMACSha1.class);

    @Override
    protected byte[] createXMLSignatureValue(Document xmlDocument, List<Element> elementsForSignature, String password) throws WSSecurityException {
        try {
            Canonicalizer canon = Canonicalizer.getInstance((String)"http://www.w3.org/2001/10/xml-exc-c14n#");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Mac mac = Mac.getInstance("HmacSHA1");
            for (Element elementToSign : elementsForSignature) {
                out.write(canon.canonicalizeSubtree((Node)elementToSign));
            }
            byte[] canonicalized = out.toByteArray();
            if (logger.isTraceEnabled()) {
                logger.trace("Canonicalized XML-Parts for signature: \n" + new String(canonicalized));
            }
            SecretKeySpec secretKey = new SecretKeySpec(password.getBytes(), "HmacSHA1");
            mac.init(secretKey);
            byte[] signature = mac.doFinal(canonicalized);
            if (logger.isDebugEnabled()) {
                logger.debug("Created HMAC-Sha1 Signature: " + Base64.encode((byte[])signature));
            }
            return signature;
        }
        catch (Exception e) {
            throw new WSSecurityException("Error on creating HMAC XML - signature ", e);
        }
    }
}

