/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.security.webservice.jaxws;

import at.itsv.security.webservice.WSSecurityInInterceptor;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.jaxws.handler.soap.SOAPMessageContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWSSecurityHandler
implements SOAPHandler<SOAPMessageContext> {
    protected static Logger logger = LoggerFactory.getLogger(AbstractWSSecurityHandler.class);
    boolean filePath = false;
    private Set<QName> headers = new HashSet<QName>();

    public final boolean handleMessage(SOAPMessageContext context) {
        SOAPMessageContextImpl cxfContext;
        if (context instanceof SOAPMessageContextImpl && (cxfContext = (SOAPMessageContextImpl)context).getWrappedMessage() instanceof SoapMessage) {
            SoapMessage cxfMessage = (SoapMessage)cxfContext.getWrappedMessage();
            Boolean outbound = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
            if (outbound == null) {
                String errorMsg = "Cannot obtain message property: javax.xml.ws.handler.message.outbound";
                logger.error(errorMsg);
                throw new IllegalStateException(errorMsg);
            }
            if (outbound.booleanValue()) {
                this.handleOutbound(cxfMessage);
            } else {
                this.handleInbound(cxfMessage);
            }
            return true;
        }
        logger.error("SOAPMessageContext or SoapMessage is no CXF-implementation. Message cannot be processed!");
        return false;
    }

    public void handleInbound(SoapMessage soapMessage) {
    }

    public void handleOutbound(SoapMessage soapMessage) {
    }

    String getDefaultConfigurationPath() {
        if (this.isFilePath()) {
            return "/sv/webservices/configuration.properties";
        }
        return "at/itsv/security/webservices/configurations";
    }

    public boolean isFilePath() {
        return this.filePath;
    }

    public final boolean handleFault(SOAPMessageContext context) {
        return false;
    }

    public final void close(MessageContext context) {
    }

    public final Set<QName> getHeaders() {
        return WSSecurityInInterceptor.HEADERS;
    }
}

