/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.tools.services.cdi;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanManagerHelper {
    private static final Logger LOG = LoggerFactory.getLogger(BeanManagerHelper.class);
    private static BeanManager root;
    private static final String JNDI_BEAN_MANAGER = "java:comp/BeanManager";

    private BeanManagerHelper() {
    }

    public static BeanManager getBeanManager() {
        if (root == null) {
            BeanManagerHelper.lookupBeanManager();
        }
        return root;
    }

    private static synchronized void lookupBeanManager() {
        if (root == null) {
            LOG.info("Lookup (and cache) BeanManager from JNDI via {}.", (Object)JNDI_BEAN_MANAGER);
            try {
                InitialContext ctx = new InitialContext();
                root = (BeanManager)ctx.lookup(JNDI_BEAN_MANAGER);
            }
            catch (NamingException e) {
                throw new IllegalStateException("Can't lookup BeanManager from JNDI via java:comp/BeanManager", e);
            }
        }
    }

    public static <T> T getFromCDI(Class<T> clazz, Annotation ... qualifiers) {
        Bean bean = (Bean)BeanManagerHelper.getBeanManager().getBeans(clazz, qualifiers).iterator().next();
        CreationalContext context = BeanManagerHelper.getBeanManager().createCreationalContext((Contextual)bean);
        Object result = BeanManagerHelper.getBeanManager().getReference(bean, clazz, context);
        return (T)result;
    }
}

