/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.tools.services.cdi;

import at.itsv.tools.services.cdi.BeanManagerHelper;
import at.itsv.tools.services.cdi.ServiceScoped;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.inject.Singleton;

@Singleton
public class ServiceContext
implements Context {
    private static final ThreadLocal<Stack<Map<Contextual<?>, Instance<?>>>> CONTEXTUAL_MAPS = new ThreadLocal();

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        Map<Contextual<?>, Instance<?>> instances = this.getContextualMap(creationalContext);
        Instance<T> instance = this.getInstance(contextual, instances);
        if (instance != null) {
            return instance.get();
        }
        if (creationalContext == null) {
            return null;
        }
        instance = new Instance<T>(contextual, creationalContext);
        instances.put(contextual, instance);
        return instance.get();
    }

    public Class<? extends Annotation> getScope() {
        return ServiceScoped.class;
    }

    public boolean isActive() {
        return true;
    }

    private <T> Instance<T> getInstance(Contextual<T> requestedContextual, Map<Contextual<?>, Instance<?>> instances) {
        return instances.get(requestedContextual);
    }

    private Map<Contextual<?>, Instance<?>> getContextualMap(CreationalContext<?> creationalContext) {
        Stack<Map<Contextual<?>, Instance<?>>> stack = CONTEXTUAL_MAPS.get();
        if (stack == null || stack.isEmpty()) {
            throw new ContextNotActiveException("This context may only be used inside a at.itsv.ta2mig.injection.ServiceContext.run(Runnable)");
        }
        return stack.peek();
    }

    private void runInternal(Runnable runnable) {
        Stack<Map<Object, Instance<Object>>> stack = CONTEXTUAL_MAPS.get();
        if (stack == null) {
            stack = new Stack();
            CONTEXTUAL_MAPS.set(stack);
        }
        stack.push(new HashMap());
        try {
            runnable.run();
        }
        finally {
            stack.pop();
        }
    }

    public static void run(Runnable runnable) {
        ServiceContext serviceContext = BeanManagerHelper.getFromCDI(ServiceContext.class, new Annotation[0]);
        serviceContext.runInternal(runnable);
    }

    protected static class Instance<T> {
        private final Contextual<T> contextual;
        private final CreationalContext<T> creationalContext;
        private final T instance;

        public Instance(Contextual<T> contextual, CreationalContext<T> creationalContext) {
            this.contextual = contextual;
            this.creationalContext = creationalContext;
            this.instance = contextual.create(creationalContext);
        }

        public void destroy() {
            this.contextual.destroy(this.instance, this.creationalContext);
        }

        public T get() {
            return this.instance;
        }

        protected Contextual<T> getContextual() {
            return this.contextual;
        }

        protected CreationalContext<T> getCreationalContext() {
            return this.creationalContext;
        }
    }
}

