/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.tools.services.converter.meldungen.mapper;

import at.itsv.tools.errorhandling.TA3JApplicationException;
import at.itsv.tools.errorhandling.system.InterceptorException;
import at.itsv.tools.keyvalue.StringKeyValue;
import at.itsv.tools.logging.SVLogger;
import at.itsv.tools.logging.SVLoggerFactory;
import at.itsv.tools.messages.MeldungsManager;
import at.itsv.tools.services.converter.meldungen.ExceptionType;
import at.itsv.tools.services.converter.meldungen.MappedMeldung;
import at.itsv.tools.services.converter.meldungen.mapper.AbstractExceptionMapper;
import at.itsv.tools.services.converter.meldungen.mapper.GetMeldung;
import java.util.List;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;

public class ApplikationsFehlerMeldungenMapper
extends AbstractExceptionMapper<TA3JApplicationException> {
    private SVLogger log = SVLoggerFactory.getSVLogger(ApplikationsFehlerMeldungenMapper.class);
    @Inject
    GetMeldung meldungHandler;

    @Override
    public List<MappedMeldung> createMeldungen(Exception exception, InvocationContext ctx) {
        String exceptionClass;
        String string = exceptionClass = null == exception ? "null" : exception.getClass().getName();
        if (exception == null || !this.canHandle(exception.getClass())) {
            throw new InterceptorException("Unable to handle exception-type " + exceptionClass + ", only " + this.getExceptionClass(), new StringKeyValue[0]);
        }
        this.log.tracing("Handling Exception {} in {}.{} with {}", new Object[]{exceptionClass, ctx.getTarget().getClass().getName(), ctx.getMethod().getName(), this.getClass().getName()});
        if (!(exception instanceof TA3JApplicationException)) {
            throw new InterceptorException("Exception " + exception.getClass().getName() + " ist keine instanceof TA3JApplicationException.", new StringKeyValue[0]);
        }
        this.addToMeldungen(ctx, (TA3JApplicationException)exception);
        return this.getMappedMeldungen();
    }

    protected void addToMeldungen(InvocationContext ctx, TA3JApplicationException exception) {
        this.log.debugging("MappedMeldungen: " + this.getMappedMeldungen(), new StringKeyValue[0]);
        this.getMappedMeldungen().add(new MappedMeldung(this.meldungHandler.getMeldung(exception), ExceptionType.Technic));
    }

    @Override
    public Class<TA3JApplicationException> getExceptionClass() {
        return TA3JApplicationException.class;
    }

    @Override
    protected Logger getLogger() {
        return null;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    protected void addToMeldungen(InvocationContext arg0) {
    }

    @Override
    protected MeldungsManager getMeldungsManager() {
        return null;
    }
}

