/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.tools.services.converter.meldungen.mapper;

import at.itsv.tools.logging.SLF4J;
import at.itsv.tools.messages.MeldungsManager;
import at.itsv.tools.messages.MeldungsTyp;
import at.itsv.tools.messages.Parameter;
import at.itsv.tools.messages.impl.ResourceBundleMeldung;
import at.itsv.tools.messages.impl.ServiceMeldungen;
import at.itsv.tools.services.converter.meldungen.ExceptionType;
import at.itsv.tools.services.converter.meldungen.mapper.AbstractExceptionMapper;
import java.util.Set;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;

public class ConstraintViolationExceptionMapper
extends AbstractExceptionMapper<ConstraintViolationException> {
    @Inject
    @SLF4J
    private Logger log;
    @Inject
    @ResourceBundleMeldung
    private MeldungsManager meldungsManager;

    @Override
    public Class<ConstraintViolationException> getExceptionClass() {
        return ConstraintViolationException.class;
    }

    @Override
    protected void addToMeldungen(InvocationContext ctx) {
        Set violations = ((ConstraintViolationException)this.getException()).getConstraintViolations();
        for (ConstraintViolation violation : violations) {
            if (violation.getPropertyPath() == null) {
                this.addMeldung(violation, violation.getLeafBean().getClass().getSimpleName(), (MeldungsTyp)ServiceMeldungen.VAL_FEHLER_OBJEKT);
                continue;
            }
            this.addMeldung(violation, violation.getPropertyPath().toString(), (MeldungsTyp)ServiceMeldungen.VAL_FEHLER_ATTRIBUT);
        }
    }

    private void addMeldung(ConstraintViolation<?> violation, String name, MeldungsTyp meldungsTyp) {
        this.addToMappedMeldungen(meldungsTyp, ExceptionType.Business, new Parameter(violation.getRootBeanClass().getSimpleName()), new Parameter(name), new Parameter(violation.getMessage()));
    }

    @Override
    protected Logger getLogger() {
        return this.log;
    }

    @Override
    protected MeldungsManager getMeldungsManager() {
        return this.meldungsManager;
    }

    @Override
    public boolean isDefault() {
        return true;
    }
}

