/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.tools.services.converter.meldungen.mapper;

import at.itsv.tools.logging.SLF4J;
import at.itsv.tools.messages.MeldungsManager;
import at.itsv.tools.messages.MeldungsTyp;
import at.itsv.tools.messages.Parameter;
import at.itsv.tools.messages.impl.ResourceBundleMeldung;
import at.itsv.tools.messages.impl.ServiceMeldungen;
import at.itsv.tools.services.converter.meldungen.ExceptionType;
import at.itsv.tools.services.converter.meldungen.mapper.AbstractExceptionMapper;
import at.itsv.tools.validations.MethodConstraintViolationException;
import at.itsv.tools.validations.MethodConstraintViolationKind;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import javax.validation.ConstraintViolation;
import org.slf4j.Logger;

public class MethodConstraintViolationExceptionMapper
extends AbstractExceptionMapper<MethodConstraintViolationException> {
    @Inject
    @SLF4J
    private Logger log;
    @Inject
    @ResourceBundleMeldung
    private MeldungsManager meldungsManager;

    @Override
    public Class<MethodConstraintViolationException> getExceptionClass() {
        return MethodConstraintViolationException.class;
    }

    @Override
    protected void addToMeldungen(InvocationContext ctx) {
        MethodConstraintViolationKind kind = ((MethodConstraintViolationException)this.getException()).getKind();
        this.log.warn("mapping constraint violation of type {}", (Object)kind);
        for (ConstraintViolation violation : ((MethodConstraintViolationException)this.getException()).getConstraintViolations()) {
            this.addToMeldung(violation, kind);
        }
    }

    private void addToMeldung(ConstraintViolation<?> violation, MethodConstraintViolationKind kind) {
        ServiceMeldungen meldungsTyp = ServiceMeldungen.VAL_FEHLER_METHODE_PARAM;
        ExceptionType exceptionType = ExceptionType.Business;
        if (MethodConstraintViolationKind.PARAM == kind) {
            meldungsTyp = ServiceMeldungen.VAL_FEHLER_METHODE_PARAM;
        } else if (MethodConstraintViolationKind.RETURN == kind) {
            meldungsTyp = ServiceMeldungen.VAL_FEHLER_METHODE_ERGEBNIS;
        }
        this.addToMappedMeldungen((MeldungsTyp)meldungsTyp, exceptionType, new Parameter(this.getViolatedItem(violation)), new Parameter(violation.getMessage()));
    }

    private String getViolatedItem(ConstraintViolation<?> violation) {
        String violatedItem = null;
        violatedItem = violation.getPropertyPath() == null ? violation.getLeafBean().getClass().getSimpleName() : violation.getPropertyPath().toString();
        return violatedItem;
    }

    @Override
    protected Logger getLogger() {
        return this.log;
    }

    @Override
    protected MeldungsManager getMeldungsManager() {
        return this.meldungsManager;
    }

    @Override
    public boolean isDefault() {
        return true;
    }
}

