/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.tools.services.converter.meldungen.mapper;

import at.itsv.tools.logging.SLF4J;
import at.itsv.tools.messages.MeldungsTyp;
import at.itsv.tools.messages.Parameter;
import at.itsv.tools.messages.impl.ServiceMeldungen;
import at.itsv.tools.services.converter.meldungen.ExceptionMeldungMapper;
import at.itsv.tools.services.converter.meldungen.ExceptionType;
import at.itsv.tools.services.converter.meldungen.mapper.AbstractExceptionMapper;
import at.itsv.tools.services.converter.meldungen.mapper.AbstractSimpleDefaultExceptionMapper;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;

public class PersistenceExceptionMapper
extends AbstractSimpleDefaultExceptionMapper<PersistenceException> {
    @Inject
    @SLF4J
    private Logger log;
    @Inject
    private ExceptionMeldungMapper exceptionMeldungMapper;

    @PostConstruct
    public void init() {
        this.setMeldung((MeldungsTyp)ServiceMeldungen.DB_FEHLER, new Parameter[0]);
        this.setExceptionType(ExceptionType.Business);
    }

    @Override
    public Class<PersistenceException> getExceptionClass() {
        return PersistenceException.class;
    }

    @Override
    protected Logger getLogger() {
        return this.log;
    }

    @Override
    protected void addToMeldungen(InvocationContext ctx) {
        if (((PersistenceException)this.getException()).getCause() instanceof Exception) {
            Exception causeException = (Exception)((PersistenceException)this.getException()).getCause();
            AbstractExceptionMapper<? extends Exception> specificMeldungsMapper = this.exceptionMeldungMapper.getFor(causeException);
            if (!specificMeldungsMapper.getExceptionClass().isAssignableFrom(this.getExceptionClass())) {
                this.addToMappedMeldungen(specificMeldungsMapper.createMeldungen(causeException, ctx));
            } else {
                this.addToMappedMeldungen(this.getMeldungsTyp(), this.getExceptionType(), new Parameter[0]);
            }
        } else {
            this.addToMappedMeldungen(this.getMeldungsTyp(), this.getExceptionType(), new Parameter[0]);
        }
    }

    @Override
    public boolean isDefault() {
        return true;
    }
}

