/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.tools.services.mapping;

import at.itsv.tools.model.AbstractEntity;
import at.itsv.tools.services.mapping.MappingHelper;
import java.util.ArrayList;
import java.util.List;

public abstract class Mapping<ENTITY extends AbstractEntity, DTO> {
    public DTO mapEntity(ENTITY entity) {
        return MappingHelper.mapViaDozer(entity, this.getMappedDtoClass());
    }

    public ENTITY mapDto(DTO dto) {
        return (ENTITY)((AbstractEntity)MappingHelper.mapViaDozer(dto, this.getMappedEntityClass()));
    }

    protected abstract Class<DTO> getMappedDtoClass();

    protected abstract Class<ENTITY> getMappedEntityClass();

    public List<DTO> mapEntities(List<ENTITY> entities) {
        ArrayList<DTO> dtos = new ArrayList<DTO>();
        for (AbstractEntity entity : entities) {
            dtos.add(this.mapEntity(entity));
        }
        return dtos;
    }

    public List<ENTITY> mapDtos(List<DTO> dtos) {
        ArrayList<ENTITY> entities = new ArrayList<ENTITY>();
        for (DTO dto : dtos) {
            entities.add(this.mapDto(dto));
        }
        return entities;
    }
}

