/*
 * Decompiled with CFR 0.152.
 */
package at.sozvers.seucc.unicode.html;

import at.esv.utils.StringFactory;
import at.sozvers.seucc.unicode.Transform;
import at.sozvers.seucc.unicode.UnicodeCharacter;
import at.sozvers.seucc.unicode.UnicodeCharacterSet;
import at.sozvers.seucc.unicode.charsets.CompleteCharacterSet;
import at.sozvers.seucc.unicode.sort.UnicodeCharacterBaseLetterComparator;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.Vector;

public class HtmlGenerator {
    public static void main(String[] args) {
        try {
            HtmlGenerator gen = new HtmlGenerator();
            gen.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run() throws Exception {
        PrintWriter out = new PrintWriter(new FileOutputStream("c:/unicode.htm"));
        UnicodeCharacterSet charset = CompleteCharacterSet.getCompleteCharacterSet();
        Map map = charset.getCharacterSet();
        Vector list = new Vector(map.values());
        UnicodeCharacterBaseLetterComparator comp = new UnicodeCharacterBaseLetterComparator();
        Collections.sort(list, comp);
        out.println("<html>");
        out.println("<head>");
        out.println("<style type=\"text/css\">");
        out.println("<!--");
        out.println(".unicode {");
        out.println("   font-family:Arial Unicode MS,Lucida Sans Unicode,Arial,sans-serif;");
        out.println("   font-size:12px;");
        out.println("   color:#000000;");
        out.println("   text-decoration:none;");
        out.println("}");
        out.println("-->");
        out.println("</style></head>");
        out.println("<body>");
        out.println("<table class=\"unicode\" border=\"1\">");
        out.println("<tr><th>Dezimal-Code</th><th>Hex-Code</th><th>Unicode Zeichen</th><th>Eingedeutschtes Zeichen</th><th>Bezeichnung des Zeichens</th></tr>");
        boolean totalcount = false;
        for (UnicodeCharacter mychar : list) {
            char i = mychar.getUnicodeChar();
            String hex = Integer.toHexString(i);
            char[] chars = new char[]{mychar.getUnicodeChar()};
            String unicodeStr = new String(chars);
            out.println("<tr>");
            out.println("<td>");
            out.println((int)mychar.getUnicodeChar());
            out.println("</td>");
            out.println("<td>");
            out.println(hex);
            out.println("</td>");
            out.println("<td>");
            hex = StringFactory.lpad((String)hex, (String)"0", (int)4);
            String hex_entity = "&#x" + hex + ";";
            out.println(hex_entity);
            out.println("</td>");
            out.println("<td>");
            out.println(Transform.eindeutschen(unicodeStr));
            out.println("</td>");
            out.println("<td>");
            out.println(mychar.getIdentifier());
            out.println("</td>");
            out.println("</tr>");
        }
        out.println("</table>");
        out.println("</body></html>");
        out.close();
    }
}

