/*
 * Decompiled with CFR 0.152.
 */
package at.sozvers.seucc.unicode.sort;

import at.sozvers.seucc.unicode.Transform;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.beanutils.BeanUtils;

public class DynaComparator
implements Comparator {
    Collection sortProperties;
    boolean baseLetter = false;
    boolean ignoreCase = true;

    public DynaComparator() {
        this.init();
    }

    public DynaComparator(String prop1, String prop2) {
        this.init();
        this.addSortProperties(prop1, prop2);
    }

    public DynaComparator(String prop1, String prop2, String prop3) {
        this.init();
        this.addSortProperties(prop1, prop2);
    }

    private void init() {
        this.sortProperties = new Vector();
    }

    private void addSortProperty(String prop) {
        this.sortProperties.add(prop);
    }

    private void addSortProperties(String prop1, String prop2) {
        this.sortProperties.add(prop1);
        this.sortProperties.add(prop2);
    }

    private void addSortProperties(String prop1, String prop2, String prop3) {
        this.sortProperties.add(prop1);
        this.sortProperties.add(prop2);
        this.sortProperties.add(prop3);
    }

    public boolean isBaseLetter() {
        return this.baseLetter;
    }

    public void setBaseLetter(boolean base_letter) {
        this.baseLetter = base_letter;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public Collection getSortProperties() {
        return this.sortProperties;
    }

    public void setSortProperties(Collection sortProperties) {
        this.sortProperties = sortProperties;
    }

    public int compare(Object obj1, Object obj2) {
        int result = 0;
        try {
            Iterator it = this.sortProperties.iterator();
            while (it.hasNext() && result == 0) {
                String propertyname = (String)it.next();
                String value1 = BeanUtils.getProperty((Object)obj1, (String)propertyname);
                String value2 = BeanUtils.getProperty((Object)obj2, (String)propertyname);
                if (this.ignoreCase) {
                    value1 = value1.toLowerCase();
                    value2 = value2.toLowerCase();
                }
                if (this.baseLetter) {
                    value1 = Transform.removeDiacriticals(value1);
                    value2 = Transform.removeDiacriticals(value2);
                }
                result = value1.compareTo(value2);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            result = 0;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            result = 0;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            result = 0;
        }
        return result;
    }

    public String toString() {
        return "Attribute: " + this.sortProperties.toString() + ", ignoreCase: " + this.ignoreCase + ", baseLetter: " + this.baseLetter;
    }
}

