/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern.sender;

import biz.paluch.logging.gelf.intern.Closer;
import biz.paluch.logging.gelf.intern.ErrorReporter;
import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.intern.GelfSender;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;

public class GelfTCPSender
implements GelfSender {
    public static final String CONNECTION_TIMEOUT = "connectionTimeout";
    public static final String READ_TIMEOUT = "readTimeout";
    public static final String RETRIES = "deliveryAttempts";
    public static final String KEEPALIVE = "keepAlive";
    private boolean shutdown = false;
    private final String host;
    private final int port;
    private final int connectTimeoutMs;
    private final int deliveryAttempts;
    private final SocketChannel socketChannel;
    private final ErrorReporter errorReporter;
    private Object connectLock = new Object();

    public GelfTCPSender(String host, int port, int connectTimeoutMs, int readTimeoutMs, ErrorReporter errorReporter) throws IOException {
        this(host, port, connectTimeoutMs, readTimeoutMs, 1, false, errorReporter);
    }

    public GelfTCPSender(String host, int port, int connectTimeoutMs, int readTimeoutMs, int deliveryAttempts, boolean keepAlive, ErrorReporter errorReporter) throws IOException {
        InetAddress.getByName(host);
        this.host = host;
        this.port = port;
        this.errorReporter = errorReporter;
        this.connectTimeoutMs = connectTimeoutMs;
        this.deliveryAttempts = deliveryAttempts < 1 ? Integer.MAX_VALUE : deliveryAttempts;
        this.socketChannel = this.createSocketChannel(readTimeoutMs, keepAlive);
    }

    private SocketChannel createSocketChannel(int readTimeoutMs, boolean keepAlive) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(false);
        socketChannel.socket().setKeepAlive(keepAlive);
        socketChannel.socket().setSoTimeout(readTimeoutMs);
        return socketChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessage(GelfMessage message) {
        if (this.shutdown) {
            return false;
        }
        Throwable exception = null;
        for (int i = 0; i < this.deliveryAttempts; ++i) {
            try {
                if (!this.socketChannel.isConnected()) {
                    Object object = this.connectLock;
                    synchronized (object) {
                        this.connect();
                    }
                }
                this.socketChannel.write(message.toTCPBuffer());
                return true;
            }
            catch (IOException e) {
                if (this.socketChannel != null) {
                    try {
                        this.socketChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                exception = e;
                continue;
            }
        }
        if (exception != null) {
            this.errorReporter.reportError(exception.getMessage(), new IOException("Cannot send data to " + this.host + ":" + this.port, exception));
        }
        return false;
    }

    protected void connect() throws IOException {
        if (this.socketChannel.isConnected()) {
            return;
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.host, this.port);
        if (this.socketChannel.connect(inetSocketAddress)) {
            return;
        }
        long connectTimeoutLeft = TimeUnit.MILLISECONDS.toNanos(this.connectTimeoutMs);
        long waitTimeoutMs = 10L;
        long waitTimeoutNs = TimeUnit.MILLISECONDS.toNanos(waitTimeoutMs);
        try {
            boolean connected;
            while (!(connected = this.socketChannel.finishConnect())) {
                Thread.sleep(waitTimeoutMs);
                if ((connectTimeoutLeft -= waitTimeoutNs) > 0L) continue;
            }
            if (!connected) {
                throw new ConnectException("Connection timed out. Cannot connect to " + inetSocketAddress + " within " + TimeUnit.NANOSECONDS.toMillis(connectTimeoutLeft) + "ms");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Connection interrupted", e);
        }
    }

    @Override
    public void close() {
        this.shutdown = true;
        Closer.close(this.socketChannel);
    }
}

