/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.utility.dispatcher.JavaDispatcher;

public abstract class FileSystem {
    public static final FileSystem INSTANCE;
    private static final boolean ACCESS_CONTROLLER;

    @AccessControllerPlugin.Enhance
    private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        PrivilegedAction<T> action;
        if (ACCESS_CONTROLLER) {
            return AccessController.doPrivileged(privilegedAction);
        }
        return action.run();
    }

    public abstract void copy(File var1, File var2) throws IOException;

    public abstract void move(File var1, File var2) throws IOException;

    static /* synthetic */ Object access$000(PrivilegedAction x0) {
        return FileSystem.doPrivileged(x0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            Class.forName("java.security.AccessController", false, null);
            ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            ACCESS_CONTROLLER = false;
        }
        catch (SecurityException securityException) {
            ACCESS_CONTROLLER = true;
        }
        INSTANCE = FileSystem.doPrivileged(CreationAction.INSTANCE);
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class ForNio2CapableVm
    extends FileSystem {
        private static final Object STATIC_MEMBER = null;
        private static final Dispatcher DISPATCHER = (Dispatcher)FileSystem.access$000(JavaDispatcher.of(Dispatcher.class));
        private static final StandardCopyOption STANDARD_COPY_OPTION = (StandardCopyOption)FileSystem.access$000(JavaDispatcher.of(StandardCopyOption.class));
        private final Method copy;
        private final Method move;

        protected ForNio2CapableVm(Method copy, Method move) {
            this.copy = copy;
            this.move = move;
        }

        @Override
        public void copy(File source, File target) throws IOException {
            Object[] option = STANDARD_COPY_OPTION.toArray(1);
            option[0] = STANDARD_COPY_OPTION.valueOf("REPLACE_EXISTING");
            try {
                this.copy.invoke(STATIC_MEMBER, DISPATCHER.toPath(source), DISPATCHER.toPath(target), option);
            }
            catch (IllegalAccessException exception) {
                throw new IllegalStateException(exception);
            }
            catch (InvocationTargetException exception) {
                Throwable cause = exception.getTargetException();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new IllegalStateException(cause);
            }
        }

        @Override
        public void move(File source, File target) throws IOException {
            Object[] option = STANDARD_COPY_OPTION.toArray(1);
            option[0] = STANDARD_COPY_OPTION.valueOf("REPLACE_EXISTING");
            try {
                this.move.invoke(STATIC_MEMBER, DISPATCHER.toPath(source), DISPATCHER.toPath(target), option);
            }
            catch (IllegalAccessException exception) {
                throw new IllegalStateException(exception);
            }
            catch (InvocationTargetException exception) {
                Throwable cause = exception.getTargetException();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new IllegalStateException(cause);
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.copy.equals(((ForNio2CapableVm)object).copy)) {
                return false;
            }
            return this.move.equals(((ForNio2CapableVm)object).move);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.copy.hashCode()) * 31 + this.move.hashCode();
        }

        @JavaDispatcher.Proxied(value="java.nio.file.StandardCopyOption")
        protected static interface StandardCopyOption {
            @JavaDispatcher.Container
            public Object[] toArray(int var1);

            @JavaDispatcher.IsStatic
            public Object valueOf(String var1);
        }

        @JavaDispatcher.Proxied(value="java.io.File")
        protected static interface Dispatcher {
            public Object toPath(File var1) throws IOException;
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class ForLegacyVm
    extends FileSystem {
        protected ForLegacyVm() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copy(File source, File target) throws IOException {
            FileInputStream inputStream = new FileInputStream(source);
            try {
                FileOutputStream outputStream = new FileOutputStream(target);
                try {
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = ((InputStream)inputStream).read(buffer)) != -1) {
                        ((OutputStream)outputStream).write(buffer, 0, length);
                    }
                }
                finally {
                    ((OutputStream)outputStream).close();
                }
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void move(File source, File target) throws IOException {
            FileInputStream inputStream = new FileInputStream(source);
            try {
                FileOutputStream outputStream = new FileOutputStream(target);
                try {
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = ((InputStream)inputStream).read(buffer)) != -1) {
                        ((OutputStream)outputStream).write(buffer, 0, length);
                    }
                }
                finally {
                    ((OutputStream)outputStream).close();
                }
            }
            finally {
                ((InputStream)inputStream).close();
            }
            if (!source.delete()) {
                source.deleteOnExit();
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return this.getClass() == object.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    protected static enum CreationAction implements PrivilegedAction<FileSystem>
    {
        INSTANCE;


        @Override
        @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger fallback")
        public FileSystem run() {
            try {
                Class<?> files = Class.forName("java.nio.file.Files");
                Class<?> path = Class.forName("java.nio.file.Path");
                Class<?> copyOption = Class.forName("[Ljava.nio.file.CopyOption;");
                return new ForNio2CapableVm(files.getMethod("copy", path, path, copyOption), files.getMethod("move", path, path, copyOption));
            }
            catch (Exception ignored) {
                return new ForLegacyVm();
            }
        }
    }
}

