/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.attributes;

import java.util.Arrays;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributeUtils;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;

public class FileAttributes
implements PlexusIoResourceAttributes {
    protected static final char VALUE_DISABLED_MODE = '-';
    protected static final char VALUE_WRITABLE_MODE = 'w';
    protected static final char VALUE_READABLE_MODE = 'r';
    protected static final char VALUE_EXECUTABLE_MODE = 'x';
    protected static final int INDEX_WORLD_EXECUTE = 9;
    protected static final int INDEX_WORLD_WRITE = 8;
    protected static final int INDEX_WORLD_READ = 7;
    protected static final int INDEX_GROUP_EXECUTE = 6;
    protected static final int INDEX_GROUP_WRITE = 5;
    protected static final int INDEX_GROUP_READ = 4;
    protected static final int INDEX_OWNER_EXECUTE = 3;
    protected static final int INDEX_OWNER_WRITE = 2;
    protected static final int INDEX_OWNER_READ = 1;
    private Integer groupId;
    private String groupName;
    private Integer userId;
    private String userName;
    private char[] mode = new char[10];

    public FileAttributes(int mode) {
        Arrays.fill(this.mode, '-');
        this.setOctalMode(mode);
    }

    public FileAttributes(String lsMOdeLine) {
        Arrays.fill(this.mode, '-');
        this.setLsModeline(lsMOdeLine);
    }

    protected char[] getLsModeParts() {
        return this.mode;
    }

    private void setLsModeParts(char[] mode) {
        if (mode.length < 10) {
            this.mode = new char[10];
            System.arraycopy(mode, 0, this.mode, 0, mode.length);
            for (int i = mode.length; i < 10; ++i) {
                this.mode[i] = 45;
            }
        } else {
            this.mode = mode;
        }
    }

    public Integer getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isGroupExecutable() {
        return this.checkFlag('-', 6);
    }

    private boolean checkFlag(char disabledValue, int idx) {
        return this.mode != null && this.mode[idx] != disabledValue;
    }

    public boolean isGroupReadable() {
        return this.checkFlag('-', 4);
    }

    public boolean isGroupWritable() {
        return this.checkFlag('-', 5);
    }

    public boolean isOwnerExecutable() {
        return this.checkFlag('-', 3);
    }

    public boolean isOwnerReadable() {
        return this.checkFlag('-', 1);
    }

    public boolean isOwnerWritable() {
        return this.checkFlag('-', 2);
    }

    public boolean isWorldExecutable() {
        return this.checkFlag('-', 9);
    }

    public boolean isWorldReadable() {
        return this.checkFlag('-', 7);
    }

    public boolean isWorldWritable() {
        return this.checkFlag('-', 8);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nFile Attributes:\n------------------------------\nuser: ");
        sb.append(this.userName == null ? "" : this.userName);
        sb.append("\ngroup: ");
        sb.append(this.groupName == null ? "" : this.groupName);
        sb.append("\nuid: ");
        sb.append(this.userId != null ? this.userId.toString() : "");
        sb.append("\ngid: ");
        sb.append(this.groupId != null ? this.groupId.toString() : "");
        sb.append("\nmode: ");
        sb.append(this.mode == null ? "" : String.valueOf(this.mode));
        return sb.toString();
    }

    public int getOctalMode() {
        int result = 0;
        if (this.isOwnerReadable()) {
            result |= 0x100;
        }
        if (this.isOwnerWritable()) {
            result |= 0x80;
        }
        if (this.isOwnerExecutable()) {
            result |= 0x40;
        }
        if (this.isGroupReadable()) {
            result |= 0x20;
        }
        if (this.isGroupWritable()) {
            result |= 0x10;
        }
        if (this.isGroupExecutable()) {
            result |= 8;
        }
        if (this.isWorldReadable()) {
            result |= 4;
        }
        if (this.isWorldWritable()) {
            result |= 2;
        }
        if (this.isWorldExecutable()) {
            result |= 1;
        }
        return result;
    }

    public String getOctalModeString() {
        return Integer.toString(this.getOctalMode(), 8);
    }

    public PlexusIoResourceAttributes setGroupId(Integer gid) {
        this.groupId = gid;
        return this;
    }

    public PlexusIoResourceAttributes setGroupName(String name) {
        this.groupName = name;
        return this;
    }

    public PlexusIoResourceAttributes setUserId(Integer uid) {
        this.userId = uid;
        return this;
    }

    public PlexusIoResourceAttributes setUserName(String name) {
        this.userName = name;
        return this;
    }

    public PlexusIoResourceAttributes setLsModeline(String modeLine) {
        this.setLsModeParts(modeLine.toCharArray());
        return this;
    }

    private void setMode(char value, int modeIdx) {
        char[] mode = this.getLsModeParts();
        mode[modeIdx] = value;
        this.setLsModeParts(mode);
    }

    private void setOctalMode(int mode) {
        this.setExecutable(3, PlexusIoResourceAttributeUtils.isOwnerExecutableInOctal(mode));
        this.setExecutable(6, PlexusIoResourceAttributeUtils.isGroupExecutableInOctal(mode));
        this.setExecutable(9, PlexusIoResourceAttributeUtils.isWorldExecutableInOctal(mode));
        this.setReadable(1, PlexusIoResourceAttributeUtils.isOwnerReadableInOctal(mode));
        this.setReadable(4, PlexusIoResourceAttributeUtils.isGroupReadableInOctal(mode));
        this.setReadable(7, PlexusIoResourceAttributeUtils.isWorldReadableInOctal(mode));
        this.setWriteable(2, PlexusIoResourceAttributeUtils.isOwnerWritableInOctal(mode));
        this.setWriteable(5, PlexusIoResourceAttributeUtils.isGroupWritableInOctal(mode));
        this.setWriteable(8, PlexusIoResourceAttributeUtils.isWorldWritableInOctal(mode));
    }

    private void setExecutable(int index, boolean executable) {
        this.setMode(executable ? (char)'x' : '-', index);
    }

    private void setReadable(int index, boolean readable) {
        this.setMode(readable ? (char)'r' : '-', index);
    }

    private void setWriteable(int index, boolean writable) {
        this.setMode(writable ? (char)'w' : '-', index);
    }

    public boolean isSymbolicLink() {
        return false;
    }
}

