/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.resources.proxy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributeUtils;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.attributes.SimpleResourceAttributes;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.components.io.functions.InputStreamTransformer;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResourceCollection;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResourceCollectionWithAttributes;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceWithAttributes;
import org.codehaus.plexus.components.io.resources.proxy.PlexusIoProxyResourceWithAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlexusIoProxyResourceCollection
extends AbstractPlexusIoResourceCollectionWithAttributes {
    private PlexusIoResourceCollection src;

    public PlexusIoProxyResourceCollection(@Nonnull PlexusIoResourceCollection src) {
        this.src = src;
    }

    public PlexusIoResourceCollection getSrc() {
        return this.src;
    }

    public void setDefaultAttributes(int uid, String userName, int gid, String groupName, int fileMode, int dirMode) {
        this.setDefaultFileAttributes(new SimpleResourceAttributes(uid, userName, gid, groupName, fileMode));
        this.setDefaultDirAttributes(new SimpleResourceAttributes(uid, userName, gid, groupName, dirMode));
    }

    public void setOverrideAttributes(int uid, String userName, int gid, String groupName, int fileMode, int dirMode) {
        this.setOverrideFileAttributes(new SimpleResourceAttributes(uid, userName, gid, groupName, fileMode));
        this.setOverrideDirAttributes(new SimpleResourceAttributes(uid, userName, gid, groupName, dirMode));
    }

    @Override
    public void setStreamTransformer(InputStreamTransformer streamTransformer) {
        if (this.src instanceof AbstractPlexusIoResourceCollection) {
            ((AbstractPlexusIoResourceCollection)this.src).setStreamTransformer(streamTransformer);
        }
        super.setStreamTransformer(streamTransformer);
    }

    protected FileSelector getDefaultFileSelector() {
        IncludeExcludeFileSelector fileSelector = new IncludeExcludeFileSelector();
        fileSelector.setIncludes(this.getIncludes());
        fileSelector.setExcludes(this.getExcludes());
        fileSelector.setCaseSensitive(this.isCaseSensitive());
        fileSelector.setUseDefaultExcludes(this.isUsingDefaultExcludes());
        return fileSelector;
    }

    private String getNonEmptyPrfix() {
        String prefix = this.getPrefix();
        if (prefix != null && prefix.length() == 0) {
            return null;
        }
        return prefix;
    }

    @Override
    public Iterator<PlexusIoResource> getResources() throws IOException {
        ArrayList<PlexusIoResource> result = new ArrayList<PlexusIoResource>();
        FileSelector fileSelector = this.getDefaultFileSelector();
        final String prefix = this.getNonEmptyPrfix();
        Iterator<PlexusIoResource> iter = this.getSrc().getResources();
        while (iter.hasNext()) {
            PlexusIoResource plexusIoResource = iter.next();
            PlexusIoResourceAttributes attrs = null;
            if (plexusIoResource instanceof PlexusIoResourceWithAttributes) {
                attrs = ((PlexusIoResourceWithAttributes)((Object)plexusIoResource)).getAttributes();
            }
            attrs = plexusIoResource.isDirectory() ? PlexusIoResourceAttributeUtils.mergeAttributes(this.getOverrideDirAttributes(), attrs, this.getDefaultDirAttributes()) : PlexusIoResourceAttributeUtils.mergeAttributes(this.getOverrideFileAttributes(), attrs, this.getDefaultFileAttributes());
            if (!fileSelector.isSelected(plexusIoResource) || !this.isSelected(plexusIoResource) || plexusIoResource.isDirectory() && !this.isIncludingEmptyDirectories()) continue;
            if (prefix != null) {
                final String name = plexusIoResource.getName();
                plexusIoResource = plexusIoResource instanceof PlexusIoResourceWithAttributes ? new PlexusIoProxyResourceWithAttributes(plexusIoResource, attrs){

                    public String getName() {
                        return prefix + name;
                    }
                } : new PlexusIoProxyResourceWithAttributes(plexusIoResource, attrs){

                    public String getName() {
                        return prefix + name;
                    }
                };
            }
            result.add(plexusIoResource);
        }
        return result.iterator();
    }

    @Override
    public String getName(PlexusIoResource resource) {
        String name = resource.getName();
        FileMapper[] mappers = this.getFileMappers();
        if (mappers != null) {
            for (FileMapper mapper : mappers) {
                name = mapper.getMappedFileName(name);
            }
        }
        return name;
    }

    @Override
    public long getLastModified() throws IOException {
        return this.src.getLastModified();
    }
}

