/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers.principal;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.auth.certs.SubjectCNMapping;
import org.jboss.security.mapping.MappingResult;
import org.jboss.security.mapping.providers.principal.AbstractPrincipalMappingProvider;

public class SubjectCNMapper
extends AbstractPrincipalMappingProvider {
    private MappingResult<Principal> result;

    public void init(Map<String, Object> opt) {
    }

    public void setMappingResult(MappingResult<Principal> res) {
        this.result = res;
    }

    public void performMapping(Map<String, Object> contextMap, Principal principal) {
        if (!(principal instanceof X500Principal)) {
            return;
        }
        if (contextMap == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("contextMap");
        }
        X509Certificate[] certs = (X509Certificate[])contextMap.get("X509");
        if (certs != null) {
            SubjectCNMapping sdn = new SubjectCNMapping();
            principal = sdn.toPrinicipal(certs);
            PicketBoxLogger.LOGGER.traceMappedX500Principal(principal);
        }
        this.result.setMappedObject((Object)principal);
    }
}

