/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.auth;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.security.jacc.PolicyContext;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.ServerAuthenticationManager;
import org.jboss.security.plugins.auth.JaasSecurityManagerBase;

public class JASPIServerAuthenticationManager
extends JaasSecurityManagerBase
implements ServerAuthenticationManager {
    private final Map<String, ServerAuthContext> serverAuthContexts = new HashMap<String, ServerAuthContext>();

    public JASPIServerAuthenticationManager() {
    }

    public JASPIServerAuthenticationManager(String securityDomain, CallbackHandler handler) {
        super(securityDomain, handler);
    }

    private ServerAuthContext getServerAuthContext(ServerAuthConfig serverConfig, MessageInfo messageInfo) {
        String authContextId = serverConfig.getAuthContextID(messageInfo);
        ServerAuthContext sctx = this.serverAuthContexts.get(authContextId);
        if (sctx == null) {
            Properties properties = new Properties();
            properties.setProperty("security-domain", super.getSecurityDomain());
            try {
                PicketBoxLogger.LOGGER.traceCreatingNewServerAuthContext(authContextId, super.getSecurityDomain());
                sctx = serverConfig.getAuthContext(authContextId, new Subject(), (Map)properties);
                this.serverAuthContexts.put(authContextId, sctx);
            }
            catch (AuthException ae) {
                SecurityContextAssociation.getSecurityContext().getData().put(AuthException.class.getName(), ae);
                PicketBoxLogger.LOGGER.errorGettingServerAuthContext(authContextId, super.getSecurityDomain(), (Throwable)ae);
            }
        }
        return sctx;
    }

    public boolean isValid(MessageInfo requestMessage, Subject clientSubject, String layer, CallbackHandler handler) {
        return this.isValid(requestMessage, clientSubject, layer, PolicyContext.getContextID(), handler);
    }

    public boolean isValid(MessageInfo messageInfo, Subject clientSubject, String layer, String appContext, CallbackHandler callbackHandler) {
        AuthConfigFactory factory = AuthConfigFactory.getFactory();
        AuthConfigProvider provider = factory.getConfigProvider(layer, appContext, null);
        if (provider == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullAuthConfigProviderForLayer(layer, appContext);
        }
        ServerAuthConfig serverConfig = null;
        try {
            serverConfig = provider.getServerAuthConfig(layer, appContext, callbackHandler);
        }
        catch (AuthException ae) {
            SecurityContextAssociation.getSecurityContext().getData().put(AuthException.class.getName(), ae);
            PicketBoxLogger.LOGGER.errorGettingServerAuthConfig(layer, appContext, (Throwable)ae);
            return false;
        }
        ServerAuthContext sctx = this.getServerAuthContext(serverConfig, messageInfo);
        if (sctx == null) {
            return false;
        }
        if (clientSubject == null) {
            clientSubject = new Subject();
        }
        Subject serviceSubject = new Subject();
        AuthStatus status = AuthStatus.FAILURE;
        try {
            status = sctx.validateRequest(messageInfo, clientSubject, serviceSubject);
        }
        catch (AuthException ae) {
            SecurityContextAssociation.getSecurityContext().getData().put(AuthException.class.getName(), ae);
            PicketBoxLogger.LOGGER.debugIgnoredException((Throwable)ae);
        }
        return AuthStatus.SUCCESS == status;
    }

    public void secureResponse(MessageInfo messageInfo, Subject serviceSubject, String layer, String appContext, CallbackHandler handler) {
        AuthConfigFactory factory = AuthConfigFactory.getFactory();
        AuthConfigProvider provider = factory.getConfigProvider(layer, appContext, null);
        if (provider == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullAuthConfigProviderForLayer(layer, appContext);
        }
        ServerAuthConfig serverConfig = null;
        try {
            serverConfig = provider.getServerAuthConfig(layer, appContext, handler);
        }
        catch (AuthException ae) {
            SecurityContextAssociation.getSecurityContext().getData().put(AuthException.class.getName(), ae);
            PicketBoxLogger.LOGGER.errorGettingServerAuthConfig(layer, appContext, (Throwable)ae);
            return;
        }
        ServerAuthContext sctx = this.getServerAuthContext(serverConfig, messageInfo);
        if (sctx == null) {
            return;
        }
        try {
            sctx.secureResponse(messageInfo, serviceSubject);
        }
        catch (AuthException ae) {
            SecurityContextAssociation.getSecurityContext().getData().put(AuthException.class.getName(), ae);
            PicketBoxLogger.LOGGER.debugIgnoredException((Throwable)ae);
        }
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject, String layer, String appContext, CallbackHandler handler) {
        AuthConfigFactory factory = AuthConfigFactory.getFactory();
        AuthConfigProvider provider = factory.getConfigProvider(layer, appContext, null);
        if (provider == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullAuthConfigProviderForLayer(layer, appContext);
        }
        ServerAuthConfig serverConfig = null;
        try {
            serverConfig = provider.getServerAuthConfig(layer, appContext, handler);
        }
        catch (AuthException ae) {
            SecurityContextAssociation.getSecurityContext().getData().put(AuthException.class.getName(), ae);
            PicketBoxLogger.LOGGER.errorGettingServerAuthConfig(layer, appContext, (Throwable)ae);
            return;
        }
        ServerAuthContext sctx = this.getServerAuthContext(serverConfig, messageInfo);
        if (sctx == null) {
            return;
        }
        try {
            sctx.cleanSubject(messageInfo, subject);
        }
        catch (AuthException ae) {
            SecurityContextAssociation.getSecurityContext().getData().put(AuthException.class.getName(), ae);
            PicketBoxLogger.LOGGER.debugIgnoredException((Throwable)ae);
        }
    }
}

