/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.datasource.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.vault.SecurityVaultException;
import org.jboss.security.vault.SecurityVaultUtil;
import org.picketbox.datasource.security.AbstractPasswordCredentialLoginModule;
import org.picketbox.datasource.security.SubjectActions;

public class ConfiguredIdentityLoginModule
extends AbstractPasswordCredentialLoginModule {
    private String principalName;
    private String userName;
    private String password;

    @Override
    public void initialize(Subject subject, CallbackHandler handler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, handler, sharedState, options);
        this.principalName = (String)options.get("principal");
        if (this.principalName == null) {
            throw new IllegalArgumentException(PicketBoxMessages.MESSAGES.missingRequiredModuleOptionMessage("principal"));
        }
        this.userName = (String)options.get("userName");
        if (this.userName == null) {
            this.userName = (String)options.get("username");
            if (this.userName == null) {
                throw new IllegalArgumentException(PicketBoxMessages.MESSAGES.missingRequiredModuleOptionMessage("username"));
            }
        }
        this.password = (String)options.get("password");
        if (this.password == null) {
            PicketBoxLogger.LOGGER.warnModuleCreationWithEmptyPassword();
            this.password = "";
        } else if (SecurityVaultUtil.isVaultFormat((String)this.password)) {
            try {
                this.password = SecurityVaultUtil.getValueAsString((String)this.password);
            }
            catch (SecurityVaultException e) {
                throw new RuntimeException(e);
            }
        }
        PicketBoxLogger.LOGGER.debugModuleOption("principal", (Object)this.principalName);
        PicketBoxLogger.LOGGER.debugModuleOption("username", (Object)this.userName);
        PicketBoxLogger.LOGGER.debugModuleOption("password", (Object)this.password);
    }

    @Override
    public boolean login() throws LoginException {
        PicketBoxLogger.LOGGER.traceBeginLogin();
        if (super.login()) {
            return true;
        }
        SimplePrincipal principal = new SimplePrincipal(this.principalName);
        SubjectActions.addPrincipals(this.subject, principal);
        this.sharedState.put("javax.security.auth.login.name", this.principalName);
        PasswordCredential cred = new PasswordCredential(this.userName, this.password.toCharArray());
        SubjectActions.addCredentials(this.subject, cred);
        this.loginOk = true;
        return true;
    }

    @Override
    protected Principal getIdentity() {
        PicketBoxLogger.LOGGER.traceBeginGetIdentity(this.principalName);
        SimplePrincipal principal = new SimplePrincipal(this.principalName);
        return principal;
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        PicketBoxLogger.LOGGER.traceBeginGetRoleSets();
        return new Group[0];
    }
}

