/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import redis.clients.jedis.Client;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.util.ClusterNodeInformation;
import redis.clients.util.ClusterNodeInformationParser;

public abstract class JedisClusterConnectionHandler {
    public static ClusterNodeInformationParser nodeInfoParser = new ClusterNodeInformationParser();
    protected Map<String, JedisPool> nodes = new HashMap<String, JedisPool>();
    protected Map<Integer, JedisPool> slots = new HashMap<Integer, JedisPool>();

    abstract Jedis getConnection();

    protected void returnConnection(Jedis connection) {
        this.nodes.get(this.getNodeKey(connection.getClient())).returnResource(connection);
    }

    public void returnBrokenConnection(Jedis connection) {
        this.nodes.get(this.getNodeKey(connection.getClient())).returnBrokenResource(connection);
    }

    abstract Jedis getConnectionFromSlot(int var1);

    public JedisClusterConnectionHandler(Set<HostAndPort> nodes) {
        this.initializeSlotsCache(nodes);
    }

    public Map<String, JedisPool> getNodes() {
        return this.nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSlotsCache(Set<HostAndPort> startNodes) {
        for (HostAndPort hostAndPort : startNodes) {
            JedisPool jp = new JedisPool(hostAndPort.getHost(), hostAndPort.getPort());
            this.nodes.clear();
            this.slots.clear();
            Jedis jedis = null;
            try {
                jedis = jp.getResource();
                this.discoverClusterNodesAndSlots(jedis);
                break;
            }
            catch (JedisConnectionException e) {
                if (jedis == null) continue;
                jp.returnBrokenResource(jedis);
                jedis = null;
            }
            finally {
                if (jedis == null) continue;
                jp.returnResource(jedis);
            }
        }
        for (HostAndPort node : startNodes) {
            this.setNodeIfNotExist(node);
        }
    }

    private void discoverClusterNodesAndSlots(Jedis jedis) {
        String localNodes = jedis.clusterNodes();
        for (String nodeInfo : localNodes.split("\n")) {
            ClusterNodeInformation clusterNodeInfo = nodeInfoParser.parse(nodeInfo, new HostAndPort(jedis.getClient().getHost(), jedis.getClient().getPort()));
            HostAndPort targetNode = clusterNodeInfo.getNode();
            this.setNodeIfNotExist(targetNode);
            this.assignSlotsToNode(clusterNodeInfo.getAvailableSlots(), targetNode);
        }
    }

    public void assignSlotToNode(int slot, HostAndPort targetNode) {
        JedisPool targetPool = this.nodes.get(this.getNodeKey(targetNode));
        if (targetPool == null) {
            this.setNodeIfNotExist(targetNode);
            targetPool = this.nodes.get(this.getNodeKey(targetNode));
        }
        this.slots.put(slot, targetPool);
    }

    public void assignSlotsToNode(List<Integer> targetSlots, HostAndPort targetNode) {
        JedisPool targetPool = this.nodes.get(this.getNodeKey(targetNode));
        if (targetPool == null) {
            this.setNodeIfNotExist(targetNode);
            targetPool = this.nodes.get(this.getNodeKey(targetNode));
        }
        for (Integer slot : targetSlots) {
            this.slots.put(slot, targetPool);
        }
    }

    protected JedisPool getRandomConnection() {
        Object[] nodeArray = this.nodes.values().toArray();
        return (JedisPool)nodeArray[new Random().nextInt(nodeArray.length)];
    }

    protected String getNodeKey(HostAndPort hnp) {
        return hnp.getHost() + ":" + hnp.getPort();
    }

    protected String getNodeKey(Client client) {
        return client.getHost() + ":" + client.getPort();
    }

    private void setNodeIfNotExist(HostAndPort node) {
        String nodeKey = this.getNodeKey(node);
        if (this.nodes.containsKey(nodeKey)) {
            return;
        }
        JedisPool nodePool = new JedisPool(node.getHost(), node.getPort());
        this.nodes.put(nodeKey, nodePool);
    }
}

