/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.charts;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Dimension2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;

public class Legend
extends Region {
    private static final int GAP = 5;
    private int rows = 0;
    private int columns = 0;
    private ListChangeListener<LegendItem> itemsListener = new ListChangeListener<LegendItem>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends LegendItem> change) {
            Legend.this.getChildren().clear();
            for (LegendItem legendItem : Legend.this.getItems()) {
                Legend.this.getChildren().add(legendItem.label);
            }
            if (Legend.this.isVisible()) {
                Legend.this.requestLayout();
            }
        }
    };
    private BooleanProperty vertical = new BooleanPropertyBase(false){

        @Override
        protected void invalidated() {
            Legend.this.requestLayout();
        }

        @Override
        public Object getBean() {
            return Legend.this;
        }

        @Override
        public String getName() {
            return "vertical";
        }
    };
    private ObjectProperty<ObservableList<LegendItem>> items = new ObjectPropertyBase<ObservableList<LegendItem>>(){
        ObservableList<LegendItem> oldItems = null;

        @Override
        protected void invalidated() {
            if (this.oldItems != null) {
                this.oldItems.removeListener(Legend.this.itemsListener);
            }
            Legend.this.getChildren().clear();
            ObservableList observableList = (ObservableList)this.get();
            if (observableList != null) {
                observableList.addListener(Legend.this.itemsListener);
                for (LegendItem legendItem : observableList) {
                    Legend.this.getChildren().add(legendItem.label);
                }
            }
            this.oldItems = (ObservableList)this.get();
            Legend.this.requestLayout();
        }

        @Override
        public Object getBean() {
            return Legend.this;
        }

        @Override
        public String getName() {
            return "items";
        }
    };

    public final boolean isVertical() {
        return this.vertical.get();
    }

    public final void setVertical(boolean bl) {
        this.vertical.set(bl);
    }

    public final BooleanProperty verticalProperty() {
        return this.vertical;
    }

    public final void setItems(ObservableList<LegendItem> observableList) {
        this.itemsProperty().set(observableList);
    }

    public final ObservableList<LegendItem> getItems() {
        return (ObservableList)this.items.get();
    }

    public final ObjectProperty<ObservableList<LegendItem>> itemsProperty() {
        return this.items;
    }

    public Legend() {
        this.setItems(FXCollections.<LegendItem>observableArrayList());
        this.getStyleClass().setAll((String[])new String[]{"chart-legend"});
    }

    private Dimension2D getTileSize() {
        double d = 0.0;
        double d2 = 0.0;
        for (LegendItem legendItem : this.getItems()) {
            d = Math.max(d, legendItem.label.prefWidth(-1.0));
            d2 = Math.max(d2, legendItem.label.prefHeight(-1.0));
        }
        return new Dimension2D(Math.ceil(d), Math.ceil(d2));
    }

    @Override
    protected double computePrefWidth(double d) {
        double d2 = d - this.getInsets().getTop() - this.getInsets().getBottom();
        Dimension2D dimension2D = this.getTileSize();
        if (d == -1.0) {
            if (this.columns <= 1) {
                return dimension2D.getWidth() + this.getInsets().getLeft() + this.getInsets().getRight();
            }
        } else {
            this.rows = (int)Math.floor(d2 / (dimension2D.getHeight() + 5.0));
            int n = this.columns = this.rows == 0 ? (int)Math.ceil(this.getItems().size()) : (int)Math.ceil((double)this.getItems().size() / (double)this.rows);
        }
        if (this.columns == 1) {
            this.rows = Math.min(this.rows, this.getItems().size());
        }
        return (double)this.columns * (dimension2D.getWidth() + 5.0) - 5.0 + this.getInsets().getLeft() + this.getInsets().getRight();
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = d - this.getInsets().getLeft() - this.getInsets().getRight();
        Dimension2D dimension2D = this.getTileSize();
        if (d == -1.0) {
            if (this.rows <= 1) {
                return dimension2D.getHeight() + this.getInsets().getTop() + this.getInsets().getBottom();
            }
        } else {
            this.columns = (int)Math.floor(d2 / (dimension2D.getWidth() + 5.0));
            int n = this.rows = this.columns == 0 ? (int)Math.ceil(this.getItems().size()) : (int)Math.ceil((double)this.getItems().size() / (double)this.columns);
        }
        if (this.rows == 1) {
            this.columns = Math.min(this.columns, this.getItems().size());
        }
        return (double)this.rows * (dimension2D.getHeight() + 5.0) - 5.0 + this.getInsets().getTop() + this.getInsets().getBottom();
    }

    @Override
    protected void layoutChildren() {
        block8: {
            Dimension2D dimension2D = this.getTileSize();
            if (this.isVertical()) {
                double d = this.getInsets().getLeft();
                for (int i = 0; i < this.columns; ++i) {
                    double d2 = this.getInsets().getTop();
                    for (int j = 0; j < this.rows; ++j) {
                        int n = i * this.rows + j;
                        if (n < this.getItems().size()) {
                            ((LegendItem)this.getItems().get(n)).label.resizeRelocate(d, d2, dimension2D.getWidth(), dimension2D.getHeight());
                            d2 += dimension2D.getHeight() + 5.0;
                            continue;
                        }
                        break block8;
                    }
                    d += dimension2D.getWidth() + 5.0;
                }
            } else {
                double d = this.getInsets().getTop();
                for (int i = 0; i < this.rows; ++i) {
                    double d3 = this.getInsets().getLeft();
                    for (int j = 0; j < this.columns; ++j) {
                        int n = i * this.columns + j;
                        if (n < this.getItems().size()) {
                            ((LegendItem)this.getItems().get(n)).label.resizeRelocate(d3, d, dimension2D.getWidth(), dimension2D.getHeight());
                            d3 += dimension2D.getWidth() + 5.0;
                            continue;
                        }
                        break block8;
                    }
                    d += dimension2D.getHeight() + 5.0;
                }
            }
        }
    }

    public static class LegendItem {
        private Label label = new Label();
        private StringProperty text = new StringPropertyBase(){

            @Override
            protected void invalidated() {
                LegendItem.this.label.setText(this.get());
            }

            @Override
            public Object getBean() {
                return LegendItem.this;
            }

            @Override
            public String getName() {
                return "text";
            }
        };
        private ObjectProperty<Node> symbol = new ObjectPropertyBase<Node>((Node)new Region()){

            @Override
            protected void invalidated() {
                Node node = (Node)this.get();
                if (node != null) {
                    node.getStyleClass().setAll((String[])new String[]{"chart-legend-item-symbol"});
                }
                LegendItem.this.label.setGraphic(node);
            }

            @Override
            public Object getBean() {
                return LegendItem.this;
            }

            @Override
            public String getName() {
                return "symbol";
            }
        };

        public final String getText() {
            return this.text.getValue();
        }

        public final void setText(String string) {
            this.text.setValue(string);
        }

        public final StringProperty textProperty() {
            return this.text;
        }

        public final Node getSymbol() {
            return (Node)this.symbol.getValue();
        }

        public final void setSymbol(Node node) {
            this.symbol.setValue(node);
        }

        public final ObjectProperty<Node> symbolProperty() {
            return this.symbol;
        }

        public LegendItem(String string) {
            this.setText(string);
            this.label.getStyleClass().add("chart-legend-item");
            this.label.setAlignment(Pos.CENTER_LEFT);
            this.label.setContentDisplay(ContentDisplay.LEFT);
            this.label.setGraphic(this.getSymbol());
            this.getSymbol().getStyleClass().setAll((String[])new String[]{"chart-legend-item-symbol"});
        }

        public LegendItem(String string, Node node) {
            this(string);
            this.setSymbol(node);
        }
    }
}

