/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc")
@Supports(value={Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class XADataSourceConnectionFactoryAdapter
extends JDBCConnectionFactoryAdapter {
    protected XADataSource m_xaDataSource;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    public XADataSourceConnectionFactoryAdapter(XADataSource xaDataSource) throws UniversalConnectionPoolException {
        if (null == xaDataSource) {
            UCPErrorHandler.throwUniversalConnectionPoolException(260);
        }
        this.m_xaDataSource = xaDataSource;
    }

    public XADataSource getXaDataSource() {
        return this.m_xaDataSource;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object createConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        void connectionRequestInfo;
        boolean bl;
        boolean bl2 = bl = (0x30000000000000L & TraceControllerImpl.feature) != 0L;
        if (!(connectionRequestInfo instanceof JDBCConnectionRetrievalInfo)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(252);
        }
        JDBCConnectionRetrievalInfo jdbcConnectionRequestInfo = (JDBCConnectionRetrievalInfo)connectionRequestInfo;
        XAConnection xaConnection = null;
        try {
            xaConnection = this.m_xaDataSource.getXAConnection(jdbcConnectionRequestInfo.getUser(), jdbcConnectionRequestInfo.getPassword());
            UniversalConnectionPool connectionPool = this.getUniversalConnectionPool();
            if (connectionPool != null && connectionPool instanceof ConnectionEventListener) {
                xaConnection.addConnectionEventListener((ConnectionEventListener)((Object)connectionPool));
            }
        }
        catch (SQLException sqlException) {
            if (bl) {
                ClioSupport.ilogThrowing($$$loggerRef$$$1, XADataSourceConnectionFactoryAdapter.class, $$$methodRef$$$1, this, sqlException);
            }
            UCPErrorHandler.throwUniversalConnectionPoolException(261, sqlException);
        }
        return xaConnection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeConnection(Object object) throws UniversalConnectionPoolException {
        void connection;
        boolean bl;
        boolean bl2 = bl = (0x30000000000000L & TraceControllerImpl.feature) != 0L;
        if (!(connection instanceof XAConnection)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(262);
        }
        XAConnection xaConnection = (XAConnection)connection;
        UniversalConnectionPool connectionPool = this.getUniversalConnectionPool();
        if (connectionPool != null && connectionPool instanceof ConnectionEventListener) {
            xaConnection.removeConnectionEventListener((ConnectionEventListener)((Object)connectionPool));
        }
        try {
            xaConnection.close();
        }
        catch (SQLException sqlException) {
            if (bl) {
                ClioSupport.ilogThrowing($$$loggerRef$$$2, XADataSourceConnectionFactoryAdapter.class, $$$methodRef$$$2, this, sqlException);
            }
            UCPErrorHandler.throwUniversalConnectionPoolException(263);
        }
    }

    static {
        try {
            $$$methodRef$$$3 = XADataSourceConnectionFactoryAdapter.class.getDeclaredConstructor(XADataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$2 = XADataSourceConnectionFactoryAdapter.class.getDeclaredMethod("closeConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$1 = XADataSourceConnectionFactoryAdapter.class.getDeclaredMethod("createConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$0 = XADataSourceConnectionFactoryAdapter.class.getDeclaredMethod("getXaDataSource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
    }
}

