/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram.draw.swing.javascriptparser;

import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.LineType;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.diagram.draw.helper.StyleException;
import com.baselet.diagram.draw.swing.javascriptparser.DrawFunction;
import com.baselet.diagram.draw.swing.javascriptparser.DrawerConfig;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class DrawerScriptable
extends ScriptableObject {
    DrawHandler drawer;
    Scriptable scope;

    public DrawerScriptable(DrawHandler drawer) {
        this.drawer = drawer;
    }

    public void setScope(Scriptable scope) {
        this.scope = scope;
    }

    public void drawCircle(final double x, final double y, final double radius, final ScriptableObject drawerConfig) {
        DrawFunction drawFunction = new DrawFunction(){

            @Override
            public void call() {
                DrawerConfig config = DrawerScriptable.this.getDrawerConfig(drawerConfig);
                DrawerScriptable.this.drawer.drawCircle(x, y, radius, config.getBgColor(), config.getFgColor(), config.getLineType(), config.getLineWidth(), config.getTransparency());
            }
        };
        this.executeDraw(drawFunction);
    }

    public void drawRectangle(final double x, final double y, final double width, final double height, final ScriptableObject drawerConfig) {
        DrawFunction drawFunction = new DrawFunction(){

            @Override
            public void call() {
                DrawerConfig config = DrawerScriptable.this.getDrawerConfig(drawerConfig);
                DrawerScriptable.this.drawer.drawRectangle(x, y, width, height, config.getBgColor(), config.getFgColor(), config.getLineType(), config.getLineWidth(), config.getTransparency());
            }
        };
        this.executeDraw(drawFunction);
    }

    public void drawLine(final double x1, final double y1, final double x2, final double y2, final ScriptableObject drawerConfig) {
        DrawFunction drawFunction = new DrawFunction(){

            @Override
            public void call() {
                DrawerConfig config = DrawerScriptable.this.getDrawerConfig(drawerConfig);
                DrawerScriptable.this.drawer.drawLine(x1, y1, x2, y2, config.getFgColor(), config.getLineType(), config.getLineWidth());
            }
        };
        this.executeDraw(drawFunction);
    }

    public void drawArc(final double x, final double y, final double width, final double height, final double start, final double extent, final boolean open, final ScriptableObject drawerConfig) {
        DrawFunction drawFunction = new DrawFunction(){

            @Override
            public void call() {
                DrawerConfig config = DrawerScriptable.this.getDrawerConfig(drawerConfig);
                DrawerScriptable.this.drawer.drawArc(x, y, width, height, start, extent, open, config.getBgColor(), config.getFgColor(), config.getLineType(), config.getLineWidth(), config.getTransparency());
            }
        };
        this.executeDraw(drawFunction);
    }

    public void drawEllipse(final double x, final double y, final double width, final double height, final ScriptableObject drawerConfig) {
        DrawFunction drawFunction = new DrawFunction(){

            @Override
            public void call() {
                DrawerConfig config = DrawerScriptable.this.getDrawerConfig(drawerConfig);
                DrawerScriptable.this.drawer.drawEllipse(x, y, width, height, config.getBgColor(), config.getFgColor(), config.getLineType(), config.getLineWidth(), config.getTransparency());
            }
        };
        this.executeDraw(drawFunction);
    }

    public void drawRectangleRound(final double x, final double y, final double width, final double height, final double radius, final ScriptableObject drawerConfig) {
        DrawFunction drawFunction = new DrawFunction(){

            @Override
            public void call() {
                DrawerConfig config = DrawerScriptable.this.getDrawerConfig(drawerConfig);
                DrawerScriptable.this.drawer.drawRectangleRound(x, y, width, height, radius, config.getBgColor(), config.getFgColor(), config.getLineType(), config.getLineWidth(), config.getTransparency());
            }
        };
        this.executeDraw(drawFunction);
    }

    public void drawText(final String multiLineWithMarkup, final double x, final double y, final String align, final ScriptableObject drawerConfig) {
        DrawFunction drawFunction = new DrawFunction(){

            @Override
            public void call() {
                DrawerConfig config = DrawerScriptable.this.getDrawerConfig(drawerConfig);
                AlignHorizontal alignHorizontal = DrawerScriptable.this.getAlignHorizontalEnumFromString(align);
                DrawerScriptable.this.drawer.print(multiLineWithMarkup, x, y, alignHorizontal, config.getFgColor());
            }
        };
        this.executeDraw(drawFunction);
    }

    public void executeDraw(DrawFunction drawFunction) {
        double oldLineWidth = this.drawer.getLineWidth();
        this.drawer.setLineWidth(Double.valueOf(this.scope.get("lw", this.scope).toString()).doubleValue());
        LineType oldLineType = this.drawer.getLineType();
        this.drawer.setLineType(this.scope.get("lt", this.scope).toString());
        ColorOwn oldColorBg = this.drawer.getBackgroundColor();
        this.drawer.setBackgroundColorAndKeepTransparency(this.scope.get("bg", this.scope).toString());
        ColorOwn oldColorFg = this.drawer.getForegroundColor();
        this.drawer.setForegroundColor(this.scope.get("fg", this.scope).toString());
        this.handleTransparency();
        drawFunction.call();
        this.drawer.setForegroundColor(oldColorFg);
        this.drawer.setBackgroundColor(oldColorBg);
        this.drawer.setLineWidth(oldLineWidth);
        this.drawer.setLineType(oldLineType);
    }

    private AlignHorizontal getAlignHorizontalEnumFromString(String align) {
        for (AlignHorizontal alignHorizontal : AlignHorizontal.values()) {
            if (!alignHorizontal.toString().equalsIgnoreCase(align)) continue;
            return alignHorizontal;
        }
        throw new StyleException("Allowed values for AlignHorizontal: center, left, right");
    }

    private void handleTransparency() {
        if (this.scope.get("transparency", this.scope) != NOT_FOUND) {
            this.drawer.setTransparency(Double.valueOf(this.scope.get("transparency", this.scope).toString()).doubleValue());
        }
    }

    private DrawerConfig getDrawerConfig(ScriptableObject drawerConfig) {
        if (drawerConfig == null) {
            return new DrawerConfig();
        }
        return new DrawerConfig(ScriptableObject.hasProperty((Scriptable)drawerConfig, (String)"bg") ? ScriptableObject.getProperty((Scriptable)drawerConfig, (String)"bg").toString() : null, ScriptableObject.hasProperty((Scriptable)drawerConfig, (String)"fg") ? ScriptableObject.getProperty((Scriptable)drawerConfig, (String)"fg").toString() : null, ScriptableObject.hasProperty((Scriptable)drawerConfig, (String)"lt") ? ScriptableObject.getProperty((Scriptable)drawerConfig, (String)"lt").toString() : null, ScriptableObject.hasProperty((Scriptable)drawerConfig, (String)"lw") ? Double.valueOf(ScriptableObject.getProperty((Scriptable)drawerConfig, (String)"lw").toString()) : null, ScriptableObject.hasProperty((Scriptable)drawerConfig, (String)"transparency") ? Double.valueOf(ScriptableObject.getProperty((Scriptable)drawerConfig, (String)"transparency").toString()) : null);
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

