/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram.io;

import com.baselet.control.config.Config;
import com.baselet.gui.CurrentGui;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ClassChooser {
    private static JFileChooser instance;
    private static final String ALLOWED_EXTENSIONS = ".*.(java|class)";
    private static final int TOO_MANY_FILES = 10;

    private static JFileChooser getInstance() {
        if (instance == null) {
            instance = new JFileChooser(Config.getInstance().getOpenFileHome());
            instance.setMultiSelectionEnabled(true);
            instance.setFileSelectionMode(2);
            instance.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return Pattern.matches(ClassChooser.ALLOWED_EXTENSIONS, f.getName()) || f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return ".java/.class file or directory";
                }
            });
            instance.setAcceptAllFileFilterUsed(false);
        }
        return instance;
    }

    public static List<String> getFilesToOpen() {
        ArrayList<String> fileNames = new ArrayList<String>();
        int returnVal = ClassChooser.getInstance().showOpenDialog(CurrentGui.getInstance().getGui().getMainFrame());
        if (returnVal == 0) {
            File[] selectedFiles;
            for (File file : selectedFiles = ClassChooser.getInstance().getSelectedFiles()) {
                ClassChooser.searchRecursively(file, fileNames);
            }
            Config.getInstance().setOpenFileHome(selectedFiles[0].getAbsoluteFile().getParent());
            if (fileNames.size() > 10 && (returnVal = JOptionPane.showConfirmDialog(CurrentGui.getInstance().getGui().getMainFrame(), "Your selection contains " + fileNames.size() + " files which may clutter up your diagram. Continue?", "Confirm selection", 2)) == 2) {
                fileNames.clear();
            }
        }
        return fileNames;
    }

    private static void searchRecursively(File file, List<String> fileNames) {
        if (Pattern.matches(ALLOWED_EXTENSIONS, file.getName())) {
            fileNames.add(file.getAbsolutePath());
        } else if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                ClassChooser.searchRecursively(f, fileNames);
            }
        }
    }
}

