/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.old.element;

import com.baselet.control.HandlerElementMap;
import com.baselet.control.basics.Converter;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.draw.helper.theme.Theme;
import com.baselet.diagram.draw.helper.theme.ThemeFactory;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.old.OldGridElement;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class ErrorOccurred
extends OldGridElement {
    private final String errorMessage;

    public ErrorOccurred() {
        this.errorMessage = "This Element has an Error!";
    }

    public ErrorOccurred(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public void paintEntity(Graphics g) {
        DiagramHandler handlerForElement = HandlerElementMap.getHandlerForElement(this);
        Graphics2D g2 = (Graphics2D)g;
        g2.drawRect(0, 0, this.getRectangle().width - 1, this.getRectangle().height - 1);
        if (handlerForElement.getDrawPanel().getSelector().isSelected(this)) {
            g2.setColor(Converter.convert(ThemeFactory.getCurrentTheme().getColor(Theme.ColorStyle.SELECTION_FG)));
        } else {
            g2.setColor(Color.red);
        }
        g2.setFont(handlerForElement.getFontHandler().getFont());
        handlerForElement.getFontHandler().writeText(g2, this.errorMessage, 0.0, 20.0, AlignHorizontal.LEFT);
        g2.setColor(this.fgColor);
    }

    @Override
    public GridElement cloneFromMe() {
        try {
            ErrorOccurred ge = new ErrorOccurred(this.errorMessage);
            ge.setPanelAttributes(this.getPanelAttributes());
            ge.setRectangle(this.getRectangle());
            HandlerElementMap.getHandlerForElement(this).setHandlerAndInitListeners(ge);
            return ge;
        }
        catch (Exception e) {
            log.error("Error at calling CloneFromMe() on entity", (Throwable)e);
            return null;
        }
    }
}

