/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.old.element;

import com.baselet.control.HandlerElementMap;
import com.baselet.control.basics.Converter;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.Direction;
import com.baselet.control.enums.LineType;
import com.baselet.control.util.Utils;
import com.baselet.diagram.SelectorOld;
import com.baselet.diagram.draw.helper.theme.Theme;
import com.baselet.diagram.draw.helper.theme.ThemeFactory;
import com.baselet.element.facet.common.LayerFacet;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.old.OldGridElement;
import com.baselet.element.old.relation.Arrow;
import com.baselet.element.old.relation.EmptyShape;
import com.baselet.element.old.relation.Multiplicity;
import com.baselet.element.old.relation.NoShape;
import com.baselet.element.old.relation.Port;
import com.baselet.element.old.relation.Qualifier;
import com.baselet.element.old.relation.Role;
import com.baselet.element.sticking.StickingPolygon;
import com.baselet.element.sticking.polygon.NoStickingPolygonGenerator;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.Collections;
import java.util.Set;
import java.util.Vector;

public class Relation
extends OldGridElement {
    String beginQualifier;
    String endQualifier;
    String beginArrow;
    String endArrow;
    String beginMultiplicity;
    String endMultiplicity;
    String beginRole;
    String endRole;
    String lineType;
    String eerRelDir;
    Vector<String> _strings;
    String clientServer;
    String beginPort;
    String endPort;
    String middleArrow;
    String csdStartText;
    String csdEndText;
    private final float SELECTBOXSIZE = 12.0f;
    private final float SELECTCIRCLESIZE = 15.0f;
    private Vector<Point> _points;

    private Vector<String> getStrings() {
        if (this._strings == null) {
            this._strings = new Vector();
        }
        return this._strings;
    }

    private void setStrings(Vector<String> v) {
        this._strings = v;
    }

    private Point getCenterOfLine() {
        Point ret = new Point();
        if (this.getLinePoints().size() % 2 == 1) {
            ret = this.getLinePoints().elementAt(this.getLinePoints().size() / 2);
        } else {
            Point p1 = this.getLinePoints().elementAt(this.getLinePoints().size() / 2);
            Point p2 = this.getLinePoints().elementAt(this.getLinePoints().size() / 2 - 1);
            ret.x = (p1.x + p2.x) / 2;
            ret.y = (p1.y + p2.y) / 2;
        }
        return ret;
    }

    @Override
    public String getAdditionalAttributes() {
        Vector<String> tmp = new Vector<String>();
        for (int i = 0; i < this.getLinePoints().size(); ++i) {
            Point p = this.getLinePoints().elementAt(i);
            String s1 = "" + p.x;
            String s2 = "" + p.y;
            tmp.add(s1);
            tmp.add(s2);
        }
        String ret = Utils.composeStrings(tmp, ";");
        return ret;
    }

    @Override
    public void setAdditionalAttributes(String s) {
        this.getLinePoints().clear();
        Vector<String> tmp = Utils.decomposeStringsIncludingEmptyStrings(s, ";");
        for (int i = 0; i < tmp.size(); i += 2) {
            int x = Integer.parseInt(tmp.elementAt(i));
            int y = Integer.parseInt(tmp.elementAt(i + 1));
            this.getLinePoints().add(new Point(x, y));
        }
    }

    @Override
    public void setPanelAttributes(String state) {
        this.beginQualifier = "";
        this.endQualifier = "";
        this.beginArrow = "";
        this.endArrow = "";
        this.beginMultiplicity = "";
        this.endMultiplicity = "";
        this.beginRole = "";
        this.endRole = "";
        this.lineType = "-";
        this.eerRelDir = "";
        this.middleArrow = "";
        this.beginPort = "";
        this.endPort = "";
        this.setStrings(null);
        super.setPanelAttributes(state);
        Vector<String> tmp = Utils.decomposeStrings(state);
        for (int i = 0; i < tmp.size(); ++i) {
            String s = tmp.elementAt(i);
            if (s.startsWith("q1=") & s.length() > 3) {
                this.beginQualifier = s.substring(3, s.length());
                continue;
            }
            if (s.startsWith("q2=") & s.length() > 3) {
                this.endQualifier = s.substring(3, s.length());
                continue;
            }
            if (s.startsWith("m1=") & s.length() > 3) {
                this.beginMultiplicity = s.substring(3, s.length());
                continue;
            }
            if (s.startsWith("m2=") & s.length() > 3) {
                this.endMultiplicity = s.substring(3, s.length());
                continue;
            }
            if (s.startsWith("r1=") & s.length() > 3) {
                this.beginRole = s.substring(3, s.length());
                continue;
            }
            if (s.startsWith("r2=") & s.length() > 3) {
                this.endRole = s.substring(3, s.length());
                continue;
            }
            if (s.startsWith("p1=") & s.length() > 3) {
                this.beginPort = s.substring(3, s.length());
                continue;
            }
            if (s.startsWith("p2=") & s.length() > 3) {
                this.endPort = s.substring(3, s.length());
                continue;
            }
            if (s.startsWith("lt=") & s.length() > 3) {
                this.csdStartText = "";
                this.csdEndText = "";
                if (s.indexOf("<[") >= 0) {
                    this.beginArrow = "compStart";
                    if (s.length() > 6) {
                        this.csdStartText = this.getCSDText(s)[0];
                        s = s.replace("<[" + this.csdStartText + "]", "<[]");
                    }
                }
                if (s.indexOf("]>") >= 0) {
                    this.endArrow = "compEnd";
                    if (s.length() > 6) {
                        this.csdEndText = this.getCSDText(s)[1];
                        s = s.replace("[" + this.csdEndText + "]>", "[]>");
                    }
                }
                if (s.indexOf("]<") >= 0) {
                    this.beginArrow = this.beginArrow + "del";
                }
                if (s.indexOf(">[") >= 0) {
                    this.endArrow = this.endArrow + "del";
                }
                if (s.indexOf(">>>>>") >= 0) {
                    this.endArrow = "<<<";
                } else if (s.indexOf(">>>>") >= 0) {
                    this.endArrow = "X";
                } else if (s.indexOf(">>>") >= 0) {
                    this.endArrow = "x";
                } else if (s.indexOf(">>") >= 0) {
                    this.endArrow = "<<";
                } else if (s.indexOf("m>") >= 0) {
                    this.endArrow = "crowsFoot";
                } else if (s.indexOf(">") >= 0 && this.endArrow.equals("")) {
                    this.endArrow = "<";
                }
                if (s.indexOf("<<<<<") >= 0) {
                    this.beginArrow = "<<<";
                } else if (s.indexOf("<<<<") >= 0) {
                    this.beginArrow = "X";
                } else if (s.indexOf("<<<") >= 0) {
                    this.beginArrow = "x";
                } else if (s.indexOf("<<") >= 0) {
                    this.beginArrow = "<<";
                } else if (s.indexOf("<m") >= 0) {
                    this.beginArrow = "crowsFoot";
                } else if (s.indexOf("<") >= 0 && this.beginArrow.equals("")) {
                    this.beginArrow = "<";
                }
                if (s.indexOf("<EER>") >= 0) {
                    this.beginArrow = "";
                    this.endArrow = "";
                    this.eerRelDir = "EER1";
                } else if (s.indexOf("<EER") >= 0) {
                    this.beginArrow = "";
                    this.endArrow = "";
                    this.eerRelDir = "EER2";
                } else if (s.indexOf("EER>") >= 0) {
                    this.beginArrow = "";
                    this.endArrow = "";
                    this.eerRelDir = "EER3";
                } else if (s.indexOf("EER") >= 0) {
                    this.beginArrow = "";
                    this.endArrow = "";
                    this.eerRelDir = "EER_SUBCLASS";
                }
                this.clientServer = "";
                if (s.indexOf("(()") >= 0) {
                    this.clientServer = "provideRequire";
                } else if (s.indexOf("())") >= 0) {
                    this.clientServer = "requireProvide";
                }
                if (s.indexOf("<(+)") >= 0) {
                    this.beginArrow = "packageStart";
                    this.clientServer = " ";
                } else if (s.indexOf("<()") >= 0) {
                    this.clientServer = "start";
                    this.beginArrow = "require";
                } else if (s.indexOf("<(") >= 0) {
                    this.clientServer = "start";
                    this.beginArrow = "provide";
                } else if (s.indexOf("<x") >= 0) {
                    this.beginArrow = "n";
                }
                if (s.indexOf("(+)>") >= 0) {
                    this.endArrow = "packageEnd";
                    this.clientServer = " ";
                } else if (s.indexOf("()>") >= 0) {
                    this.clientServer = "end";
                    this.endArrow = "require";
                } else if (s.indexOf(")>") >= 0) {
                    this.clientServer = "end";
                    this.endArrow = "provide";
                } else if (s.indexOf("x>") >= 0) {
                    this.endArrow = "n";
                }
                if (s.indexOf(">()") >= 0 && this.clientServer.equals("")) {
                    this.middleArrow = "delegationArrowRight";
                    if (this.endArrow.equals("<")) {
                        this.endArrow = "";
                    }
                } else if (s.indexOf("()<") >= 0 && this.clientServer.equals("")) {
                    this.middleArrow = "delegationArrowLeft";
                    if (this.beginArrow.equals("<")) {
                        this.beginArrow = "";
                    }
                } else if (s.indexOf("()") >= 0 && this.clientServer.equals("")) {
                    this.middleArrow = "delegation";
                } else if (s.indexOf("(") >= 0 && this.clientServer.equals("")) {
                    this.middleArrow = "delegationStart";
                    this.lineType = "-.";
                } else if (s.indexOf(")") >= 0 && this.clientServer.equals("")) {
                    this.middleArrow = "delegationEnd";
                    this.lineType = ".-";
                }
                if (s.indexOf(".") >= 0 & s.indexOf("-") >= s.indexOf(".")) {
                    this.lineType = ".-";
                    continue;
                }
                if (s.indexOf("-") >= 0 & s.indexOf(".") >= s.indexOf("-")) {
                    this.lineType = "-.";
                    continue;
                }
                if (s.indexOf(LineType.DOTTED.getValue()) >= 0) {
                    this.lineType = LineType.DOTTED.getValue();
                    continue;
                }
                if (s.indexOf(LineType.DASHED.getValue()) >= 0) {
                    this.lineType = LineType.DASHED.getValue();
                    continue;
                }
                if (s.indexOf(LineType.SOLID.getValue()) >= 0) {
                    this.lineType = LineType.SOLID.getValue();
                    continue;
                }
                if (s.substring(3, s.length()).indexOf(LineType.DOUBLE.getValue()) >= 0) {
                    this.lineType = LineType.DOUBLE.getValue();
                    continue;
                }
                if (s.indexOf(LineType.DOUBLE_DOTTED.getValue()) >= 0) {
                    this.lineType = LineType.DOUBLE_DOTTED.getValue();
                    continue;
                }
                if (s.indexOf(LineType.DOUBLE_DASHED.getValue()) < 0) continue;
                this.lineType = LineType.DOUBLE_DASHED.getValue();
                continue;
            }
            this.getStrings().add(s);
        }
    }

    public static Vector<Point> getIntersectingLineSegment(Area r, Vector<Point> points) {
        Vector<Point> ret = new Vector<Point>();
        Point pp_end = points.elementAt(points.size() - 1);
        Point pp_start = points.elementAt(points.size() - 2);
        for (int i = 1; i < points.size(); ++i) {
            pp_end = points.elementAt(i);
            if (r.contains(Converter.convert(pp_end))) continue;
            pp_start = points.elementAt(i - 1);
            ret.add(pp_start);
            ret.add(pp_end);
            return ret;
        }
        ret.add(pp_start);
        ret.add(pp_end);
        return ret;
    }

    public static Point moveNextTo(Area rFixed, Rectangle rMovable, Point pStart, Point pEnd) {
        int centerDiffX = -rMovable.getWidth() / 2;
        int centerDiffY = -rMovable.getHeight() / 2;
        int vectorX = pEnd.x - pStart.x;
        int vectorY = pEnd.y - pStart.y;
        int startx = pStart.x;
        int starty = pStart.y;
        int endx = pEnd.x;
        int endy = pEnd.y;
        int i = 0;
        while (true) {
            rMovable.setLocation((endx += vectorX) + centerDiffX, (endy += vectorY) + centerDiffY);
            if (!rFixed.intersects(Converter.convert(rMovable))) break;
            ++i;
        }
        int newx = 0;
        int newy = 0;
        for (int i2 = 0; i2 < 10; ++i2) {
            newx = (endx + startx) / 2;
            newy = (endy + starty) / 2;
            rMovable.setLocation(newx + centerDiffX, newy + centerDiffY);
            if (rFixed.intersects(Converter.convert(rMovable))) {
                startx = newx;
                starty = newy;
                continue;
            }
            endx = newx;
            endy = newy;
        }
        Point ret = new Point(newx + centerDiffX, newy + centerDiffY);
        return ret;
    }

    public boolean lineUp(Vector<Rectangle> shapes, Vector<Point> points, int hotspotx, int hotspoty) {
        float zoom = HandlerElementMap.getHandlerForElement(this).getZoomFactor();
        for (int i = points.size() - 1; i > 0; --i) {
            Point p1 = points.elementAt(i);
            Point p2 = points.elementAt(i - 1);
            if (!(p1.x == p2.x & p1.y == p2.y)) continue;
            points.removeElementAt(i);
        }
        if (points.size() <= 1) {
            return false;
        }
        if (shapes.size() <= 1) {
            return true;
        }
        Area tmpArea = new Area();
        for (int i = 0; i < shapes.size() - 1; ++i) {
            Rectangle r = shapes.elementAt(i);
            if (i == 0) {
                Point p = points.elementAt(0);
                r.setLocation(p.x - hotspotx, p.y - hotspoty);
            }
            Area a = new Area(Converter.convert(r));
            tmpArea.add(a);
            Rectangle rMovable = shapes.elementAt(i + 1);
            Vector<Point> tmp = Relation.getIntersectingLineSegment(tmpArea, points);
            Point startIntersectingLine = tmp.elementAt(0);
            Point endIntersectingLine = tmp.elementAt(1);
            Point res = Relation.moveNextTo(tmpArea, rMovable, startIntersectingLine, endIntersectingLine);
            if (rMovable instanceof Arrow) {
                Point bottomDown;
                Point upperLeft;
                Point end;
                Point start;
                Arrow arrow = (Arrow)rMovable;
                Point diffA = new Point(-startIntersectingLine.x + endIntersectingLine.x, -startIntersectingLine.y + endIntersectingLine.y);
                Point diffB1 = new Point(diffA.y, -diffA.x);
                Point diffB2 = new Point(-diffB1.x, -diffB1.y);
                Point a1 = new Point(2 * diffA.x + diffB1.x, 2 * diffA.y + diffB1.y);
                Point a2 = new Point(2 * diffA.x + diffB2.x, 2 * diffA.y + diffB2.y);
                a1 = Utils.normalize(a1, (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize());
                a2 = Utils.normalize(a2, (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize());
                arrow.setArrowEndA(a1);
                arrow.setArrowEndB(a2);
                if (arrow.getString().equals("n")) {
                    Point start2 = startIntersectingLine;
                    Point end2 = endIntersectingLine;
                    Point vectorA = new Point(-start2.x + end2.x, -start2.y + end2.y);
                    Point vectorDown = new Point(vectorA.y, -vectorA.x);
                    Point vectorUp = new Point(-vectorDown.x, -vectorDown.y);
                    Point newA1 = new Point(4 * vectorA.x + vectorDown.x, 4 * vectorA.y + vectorDown.y);
                    Point newA2 = new Point(4 * vectorA.x + vectorUp.x, 4 * vectorA.y + diffB2.y);
                    newA1 = Utils.normalize(newA1, (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize() * 2);
                    newA2 = Utils.normalize(newA2, (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize() * 2);
                    arrow.setCrossEndA(newA1);
                    arrow.setCrossEndB(newA2);
                } else if (arrow.getString().equals("require")) {
                    int size = (int)(20.0f * zoom);
                    start = startIntersectingLine;
                    end = endIntersectingLine;
                    upperLeft = new Point();
                    bottomDown = new Point();
                    if (start.getX() > end.getX()) {
                        upperLeft = new Point(0, -size / 2);
                        bottomDown = new Point(size, size / 2);
                    } else if (start.getX() < end.getX()) {
                        upperLeft = new Point(-size, -size / 2);
                        bottomDown = new Point(0, size / 2);
                    } else if (start.getX() == end.getX()) {
                        if (start.getY() < end.getY()) {
                            upperLeft = new Point(-size / 2, -size);
                            bottomDown = new Point(size / 2, 0);
                        } else if (start.getY() > end.getY()) {
                            upperLeft = new Point(-size / 2, 0);
                            bottomDown = new Point(size / 2, size);
                        }
                    }
                    arrow.setCrossEndA(upperLeft);
                    arrow.setCrossEndB(bottomDown);
                } else if (arrow.getString().equals("provide")) {
                    int size = (int)(30.0f * zoom);
                    start = startIntersectingLine;
                    end = endIntersectingLine;
                    upperLeft = new Point();
                    bottomDown = new Point();
                    if (start.getX() > end.getX()) {
                        upperLeft = new Point(0, -size / 2);
                        bottomDown = new Point(size, size / 2);
                        arrow.setArcStart(90);
                        arrow.setArcEnd(180);
                    } else if (start.getX() < end.getX()) {
                        upperLeft = new Point(-size, -size / 2);
                        bottomDown = new Point(0, size / 2);
                        arrow.setArcStart(90);
                        arrow.setArcEnd(-180);
                    } else if (start.getX() == end.getX()) {
                        if (start.getY() < end.getY()) {
                            upperLeft = new Point(-size / 2, -size);
                            bottomDown = new Point(size / 2, 0);
                            arrow.setArcStart(0);
                            arrow.setArcEnd(-180);
                        } else if (start.getY() > end.getY()) {
                            upperLeft = new Point(-size / 2, 0);
                            bottomDown = new Point(size / 2, size);
                            arrow.setArcStart(0);
                            arrow.setArcEnd(180);
                        }
                    }
                    arrow.setCrossEndA(upperLeft);
                    arrow.setCrossEndB(bottomDown);
                }
            }
            rMovable.setLocation(res.x, res.y);
        }
        return true;
    }

    @Override
    public boolean isInRange(Rectangle rect1) {
        for (Point p : this.getLinePoints()) {
            Point realPoint = new Point(p.getX() + this.getRectangle().x, p.getY() + this.getRectangle().y);
            if (rect1.contains(realPoint)) continue;
            return false;
        }
        return true;
    }

    public boolean isOnLine(int i) {
        if (i - 1 >= 0 & i + 1 < this.getLinePoints().size()) {
            Point x1 = this.getLinePoints().elementAt(i - 1);
            Point x2 = this.getLinePoints().elementAt(i + 1);
            Point p = this.getLinePoints().elementAt(i);
            if (p.distance(x1) + p.distance(x2) < x1.distance(x2) + 5.0) {
                return true;
            }
        }
        return false;
    }

    public int getWhereToInsert(Point p) {
        for (int i = 0; i < this.getLinePoints().size() - 1; ++i) {
            Point x1 = this.getLinePoints().elementAt(i);
            Point x2 = this.getLinePoints().elementAt(i + 1);
            if (!(p.distance(x1) + p.distance(x2) < x1.distance(x2) + 5.0)) continue;
            return i + 1;
        }
        return -1;
    }

    public int getLinePoint(Point p) {
        float zoom = HandlerElementMap.getHandlerForElement(this).getZoomFactor();
        for (int i = 0; i < this.getLinePoints().size(); ++i) {
            Point x = this.getLinePoints().elementAt(i);
            if (!(p.distance(x) < (double)(15.0f * zoom))) continue;
            return i;
        }
        return -1;
    }

    private <T> Vector<T> flipVector(Vector<T> v) {
        Vector<T> ret = new Vector<T>();
        for (int i = v.size() - 1; i >= 0; --i) {
            ret.add(v.elementAt(i));
        }
        return ret;
    }

    @Override
    public boolean contains(java.awt.Point p) {
        for (GridElement other : HandlerElementMap.getHandlerForElement(this).getDrawPanel().getGridElements()) {
            SelectorOld s = HandlerElementMap.getHandlerForElement(other).getDrawPanel().getSelector();
            if (other == this || !(other instanceof Relation) || !s.isSelected(other)) continue;
            int xDist = this.getRectangle().x - other.getRectangle().x;
            int yDist = this.getRectangle().y - other.getRectangle().y;
            Point modifiedP = new Point(p.x + xDist, p.y + yDist);
            boolean containsHelper = ((Relation)other).calcContains(modifiedP);
            if (!s.isSelected(other) || !containsHelper) continue;
            return false;
        }
        return this.calcContains(Converter.convert(p));
    }

    private boolean calcContains(Point p) {
        int i;
        float zoom = HandlerElementMap.getHandlerForElement(this).getZoomFactor();
        for (i = 0; i < this.getLinePoints().size(); ++i) {
            Point x = this.getLinePoints().elementAt(i);
            if (!(p.distance(x) < (double)(15.0f * zoom))) continue;
            return true;
        }
        for (i = 0; i < this.getLinePoints().size() - 1; ++i) {
            double i1y;
            double ay;
            double p2y;
            Point x1 = this.getLinePoints().elementAt(i);
            Point x2 = this.getLinePoints().elementAt(i + 1);
            if (p.distance(x1) + p.distance(x2) > x1.distance(x2) + 5.0) continue;
            double p1x = x2.getX() - x1.getX();
            double p1y = x2.getY() - x1.getY();
            double p2x = p.getX() - x1.getX();
            double c = (p1x * p2x + p1y * (p2y = (double)(p.getY() - x1.getY()))) / (p1x * p1x + p1y * p1y);
            double i1x = p1x * c;
            double ax = i1x - p2x;
            double a = Math.sqrt(ax * ax + (ay = (i1y = p1y * c) - p2y) * ay);
            if (!(a < 5.0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(int x, int y) {
        return this.contains(new java.awt.Point(x, y));
    }

    public Vector<Point> getLinePoints() {
        if (this._points == null) {
            this._points = new Vector();
        }
        return this._points;
    }

    public void moveLinePoint(int index, int diffx, int diffy) {
        Point p = this.getLinePoints().elementAt(index);
        p.move(diffx, diffy);
        this.repaint();
    }

    @Override
    public GridElement cloneFromMe() {
        Relation c = new Relation();
        c.setPanelAttributes(this.getPanelAttributes());
        c.setAdditionalAttributes(this.getAdditionalAttributes());
        c.setVisible(true);
        c.setRectangle(this.getRectangle());
        HandlerElementMap.getHandlerForElement(this).setHandlerAndInitListeners(c);
        return c;
    }

    public Polygon getWholeLinePolygon() {
        Point mid;
        float zoom = HandlerElementMap.getHandlerForElement(this).getZoomFactor();
        Polygon p = new Polygon();
        int s = this.getLinePoints().size();
        if (s % 2 == 0 && s > 0) {
            mid = this.getCenterOfLine();
        } else if (s > 2) {
            Point p1 = this.getLinePoints().elementAt(this.getLinePoints().size() / 2);
            Point p2 = this.getLinePoints().elementAt(this.getLinePoints().size() / 2 + 1);
            mid = new Point((p1.x + p2.x) / 2, (p1.y + p2.y) / 2);
        } else {
            return null;
        }
        int size = (int)(12.0f * zoom);
        p.addPoint(mid.x - (size /= 2), mid.y - size);
        p.addPoint(mid.x + size, mid.y - size);
        p.addPoint(mid.x + size, mid.y + size);
        p.addPoint(mid.x - size, mid.y + size);
        return p;
    }

    public boolean isWholeLine(int x, int y) {
        Polygon p = this.getWholeLinePolygon();
        if (p == null) {
            return false;
        }
        return p.contains(x, y);
    }

    @Override
    public void paintEntity(Graphics g) {
        int i;
        int i2;
        int i3;
        Role r;
        double broadestText;
        Multiplicity m;
        TextLayout tl;
        EmptyShape e;
        Arrow a;
        Qualifier q;
        TextLayout tl2;
        float zoom = HandlerElementMap.getHandlerForElement(this).getZoomFactor();
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(HandlerElementMap.getHandlerForElement(this).getFontHandler().getFont());
        this.colorize(g2);
        g2.setColor(this.fgColor);
        Vector<Rectangle> startShapes = new Vector<Rectangle>();
        Vector<Rectangle> endShapes = new Vector<Rectangle>();
        startShapes.add(new NoShape());
        endShapes.add(new NoShape());
        if (this.beginQualifier != null && this.beginQualifier.length() > 0) {
            tl2 = new TextLayout(this.beginQualifier, HandlerElementMap.getHandlerForElement(this).getFontHandler().getFont(), g2.getFontRenderContext());
            q = new Qualifier(this.beginQualifier, 0, 0, (int)tl2.getBounds().getWidth() + (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize() * 2, (int)tl2.getBounds().getHeight() + (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize() / 2);
            startShapes.add(q);
        }
        if (this.endQualifier != null && this.endQualifier.length() > 0) {
            tl2 = new TextLayout(this.endQualifier, HandlerElementMap.getHandlerForElement(this).getFontHandler().getFont(), g2.getFontRenderContext());
            q = new Qualifier(this.endQualifier, 0, 0, (int)tl2.getBounds().getWidth() + (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize() * 2, (int)tl2.getBounds().getHeight() + (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize() / 2);
            endShapes.add(q);
        }
        if (this.beginArrow != null && this.beginArrow.length() > 0) {
            a = new Arrow(this.beginArrow);
            startShapes.add(a);
        }
        if (this.endArrow != null && this.endArrow.length() > 0) {
            a = new Arrow(this.endArrow);
            endShapes.add(a);
        }
        if (this.beginMultiplicity != null && this.beginMultiplicity.length() > 0) {
            e = new EmptyShape((int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize());
            startShapes.add(e);
            tl = new TextLayout(this.beginMultiplicity, HandlerElementMap.getHandlerForElement(this).getFontHandler().getFont(), g2.getFontRenderContext());
            m = new Multiplicity(this.beginMultiplicity, 0, 0, (int)tl.getBounds().getWidth(), (int)tl.getBounds().getHeight());
            startShapes.add(m);
        }
        if (this.endMultiplicity != null && this.endMultiplicity.length() > 0) {
            e = new EmptyShape((int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize());
            endShapes.add(e);
            tl = new TextLayout(this.endMultiplicity, HandlerElementMap.getHandlerForElement(this).getFontHandler().getFont(), g2.getFontRenderContext());
            m = new Multiplicity(this.endMultiplicity, 0, 0, (int)tl.getBounds().getWidth(), (int)tl.getBounds().getHeight());
            endShapes.add(m);
        }
        if (this.beginRole != null && this.beginRole.length() > 0) {
            e = new EmptyShape((int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize());
            startShapes.add(e);
            int position = 0;
            int lineBreaks = 0;
            broadestText = HandlerElementMap.getHandlerForElement(this).getFontHandler().getTextWidth(this.beginRole);
            while (position != 1) {
                int positionNew = this.beginRole.indexOf("\\\\", position);
                if (position == 0 && positionNew != -1) {
                    broadestText = 0.0;
                }
                if (positionNew != -1) {
                    broadestText = Math.max(broadestText, HandlerElementMap.getHandlerForElement(this).getFontHandler().getTextWidth(this.beginRole.substring(position, positionNew)));
                    if (this.beginRole.lastIndexOf("\\\\") + 2 != this.beginRole.length()) {
                        broadestText = Math.max(broadestText, HandlerElementMap.getHandlerForElement(this).getFontHandler().getTextWidth(this.beginRole.substring(this.beginRole.lastIndexOf("\\\\") + 2, this.beginRole.length())));
                    }
                    ++lineBreaks;
                }
                position = positionNew + 2;
            }
            r = new Role(this.beginRole, 0, 0, (int)broadestText, lineBreaks * (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize() + (lineBreaks + 2) * (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getDistanceBetweenTexts());
            startShapes.add(r);
        }
        if (this.endRole != null && this.endRole.length() > 0) {
            e = new EmptyShape((int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize());
            endShapes.add(e);
            int position = 0;
            int lineBreaks = 0;
            broadestText = HandlerElementMap.getHandlerForElement(this).getFontHandler().getTextWidth(this.endRole);
            while (position != 1) {
                int positionNew = this.endRole.indexOf("\\\\", position);
                if (position == 0 && positionNew != -1) {
                    broadestText = 0.0;
                }
                if (positionNew != -1) {
                    broadestText = Math.max(broadestText, HandlerElementMap.getHandlerForElement(this).getFontHandler().getTextWidth(this.endRole.substring(position, positionNew)));
                    if (this.endRole.lastIndexOf("\\\\") + 2 != this.endRole.length()) {
                        broadestText = Math.max(broadestText, HandlerElementMap.getHandlerForElement(this).getFontHandler().getTextWidth(this.endRole.substring(this.endRole.lastIndexOf("\\\\") + 2, this.endRole.length())));
                    }
                    ++lineBreaks;
                }
                position = positionNew + 2;
            }
            r = new Role(this.endRole, 0, 0, (int)broadestText, lineBreaks * (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize() + (lineBreaks + 2) * (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getDistanceBetweenTexts());
            endShapes.add(r);
        }
        if (this.beginPort != null && this.beginPort.length() > 0) {
            e = new EmptyShape((int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize());
            startShapes.add(e);
            TextLayout tl3 = new TextLayout(this.beginPort, HandlerElementMap.getHandlerForElement(this).getFontHandler().getFont(), g2.getFontRenderContext());
            Port p = new Port(this.beginPort, 0, 0, (int)tl3.getBounds().getWidth(), (int)tl3.getBounds().getHeight());
            startShapes.add(p);
        }
        if (this.endPort != null && this.endPort.length() > 0) {
            e = new EmptyShape((int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize());
            endShapes.add(e);
            TextLayout tl4 = new TextLayout(this.endPort, HandlerElementMap.getHandlerForElement(this).getFontHandler().getFont(), g2.getFontRenderContext());
            Port p = new Port(this.endPort, 0, 0, (int)tl4.getBounds().getWidth(), (int)tl4.getBounds().getHeight());
            endShapes.add(p);
        }
        Vector<Point> startPoints = new Vector<Point>(this.getLinePoints());
        Vector<Point> endPoints = this.flipVector(startPoints);
        boolean a2 = this.lineUp(startShapes, startPoints, 0, 0);
        boolean b = this.lineUp(endShapes, endPoints, 0, 0);
        if (!a2 || !b) {
            return;
        }
        if (this.lineType.equals("-.")) {
            g2.setStroke(Utils.getStroke(LineType.SOLID, 1.0f));
        } else if (this.lineType.equals(".-")) {
            g2.setStroke(Utils.getStroke(LineType.DASHED, 1.0f));
        } else if (this.lineType.equals(LineType.SOLID.getValue())) {
            g2.setStroke(Utils.getStroke(LineType.SOLID, 1.0f));
        } else if (this.lineType.equals(LineType.DASHED.getValue())) {
            g2.setStroke(Utils.getStroke(LineType.DASHED, 1.0f));
        } else if (this.lineType.equals(LineType.DOTTED.getValue())) {
            g2.setStroke(Utils.getStroke(LineType.DOTTED, 1.0f));
        } else if (this.lineType.equals(LineType.DOUBLE.getValue())) {
            g2.setStroke(Utils.getStroke(LineType.DOUBLE, 1.0f));
        } else if (this.lineType.equals(LineType.DOUBLE_DASHED.getValue())) {
            g2.setStroke(Utils.getStroke(LineType.DOUBLE_DASHED, 1.0f));
        } else if (this.lineType.equals(LineType.DOUBLE_DOTTED.getValue())) {
            g2.setStroke(Utils.getStroke(LineType.DOUBLE_DOTTED, 1.0f));
        }
        for (i3 = 0; i3 < this.getLinePoints().size() - 1; ++i3) {
            Point p2;
            Point p1;
            if ((double)i3 == Math.floor((double)(this.getLinePoints().size() - 1) / 2.0)) {
                double winkel;
                int cy;
                int cx;
                AffineTransform at2;
                AffineTransform at;
                Point mitte;
                Point px2;
                Point px1;
                p1 = this.getLinePoints().elementAt(i3);
                p2 = this.getLinePoints().elementAt(i3 + 1);
                Point pm = new Point(p1.x - (p1.x - p2.x) / 2, p1.y - (p1.y - p2.y) / 2);
                g2.drawLine(p1.x, p1.y, pm.x, pm.y);
                if (this.lineType.equals("-.")) {
                    g2.setStroke(Utils.getStroke(LineType.DASHED, 1.0f));
                }
                if (this.lineType.equals(".-")) {
                    g2.setStroke(Utils.getStroke(LineType.SOLID, 1.0f));
                }
                g2.drawLine(pm.x, pm.y, p2.x, p2.y);
                if (this.eerRelDir.indexOf("EER_SUBCLASS") >= 0) {
                    px1 = this.getLinePoints().elementAt(i3);
                    px2 = this.getLinePoints().elementAt(i3 + 1);
                    mitte = new Point(px1.x - (px1.x - px2.x) / 2, px1.y - (px1.y - px2.y) / 2);
                    at = g2.getTransform();
                    at2 = (AffineTransform)at.clone();
                    cx = mitte.x;
                    cy = mitte.y;
                    winkel = Utils.getAngle(px1.x, px1.y, px2.x, px2.y);
                    at2.rotate(winkel, cx, cy);
                    g2.setTransform(at2);
                    g2.setColor(this.fgColor);
                    g2.setStroke(Utils.getStroke(LineType.SOLID, 2.0f));
                    g2.drawArc(mitte.x, mitte.y - (int)(10.0f * zoom), (int)(20.0f * zoom), (int)(20.0f * zoom), 90, 180);
                    g2.setStroke(Utils.getStroke(LineType.SOLID, 1.0f));
                    g2.setTransform(at);
                } else if (this.eerRelDir.indexOf("EER") >= 0) {
                    px1 = this.getLinePoints().elementAt(i3);
                    px2 = this.getLinePoints().elementAt(i3 + 1);
                    mitte = new Point(px1.x - (px1.x - px2.x) / 2, px1.y - (px1.y - px2.y) / 2);
                    int recSize = (int)(20.0f * zoom);
                    Point r1 = new Point(mitte.x, mitte.y - recSize);
                    Point r2 = new Point(mitte.x + recSize, mitte.y);
                    Point r3 = new Point(mitte.x, mitte.y + recSize);
                    Point r4 = new Point(mitte.x - recSize, mitte.y);
                    Polygon po1 = new Polygon();
                    po1.addPoint(r1.x, r1.y);
                    po1.addPoint(r2.x, r2.y);
                    po1.addPoint(r3.x, r3.y);
                    Polygon po2 = new Polygon();
                    po2.addPoint(r1.x, r1.y);
                    po2.addPoint(r3.x, r3.y);
                    po2.addPoint(r4.x, r4.y);
                    AffineTransform at3 = g2.getTransform();
                    AffineTransform at22 = (AffineTransform)at3.clone();
                    int cx2 = mitte.x;
                    int cy2 = mitte.y;
                    double winkel2 = Utils.getAngle(px1.x, px1.y, px2.x, px2.y);
                    at22.rotate(winkel2, cx2, cy2);
                    g2.setTransform(at22);
                    if (this.eerRelDir.equals("EER1")) {
                        g2.setColor(this.fgColor);
                        g2.fillPolygon(po1);
                        g2.fillPolygon(po2);
                    } else if (this.eerRelDir.equals("EER2")) {
                        g2.setColor(this.bgColor);
                        g2.fillPolygon(po2);
                        g2.setColor(this.fgColor);
                        g2.fillPolygon(po1);
                    } else if (this.eerRelDir.equals("EER3")) {
                        g2.setColor(this.bgColor);
                        g2.fillPolygon(po1);
                        g2.setColor(this.fgColor);
                        g2.fillPolygon(po2);
                    }
                    g2.setColor(this.fgColor);
                    g2.draw(po1);
                    g2.draw(po2);
                    g2.setTransform(at3);
                } else if (this.clientServer != null && this.clientServer.indexOf("rovide") >= 0) {
                    px1 = this.getLinePoints().elementAt(i3);
                    px2 = this.getLinePoints().elementAt(i3 + 1);
                    mitte = new Point(px1.x - (px1.x - px2.x) / 2, px1.y - (px1.y - px2.y) / 2);
                    at = g2.getTransform();
                    at2 = (AffineTransform)at.clone();
                    cx = mitte.x;
                    cy = mitte.y;
                    winkel = Utils.getAngle(px1.x, px1.y, px2.x, px2.y);
                    at2.rotate(winkel, cx, cy);
                    g2.setTransform(at2);
                    Point outerArc = new Point(mitte.x - (int)(15.0f * zoom), mitte.y - (int)(15.0f * zoom));
                    Point innerCircle = new Point();
                    g2.setColor(Color.white);
                    g2.fillOval(outerArc.x, outerArc.y, (int)(30.0f * zoom), (int)(30.0f * zoom));
                    g2.setColor(this.fgColor);
                    g2.setStroke(Utils.getStroke(LineType.SOLID, 1.0f));
                    if (this.clientServer.equals("provideRequire")) {
                        g2.drawArc(outerArc.x, outerArc.y, (int)(30.0f * zoom), (int)(30.0f * zoom), 90, 180);
                        innerCircle = new Point(mitte.x - (int)(5.0f * zoom), mitte.y - (int)(10.0f * zoom));
                    } else if (this.clientServer.equals("requireProvide")) {
                        g2.drawArc(outerArc.x, outerArc.y, (int)(30.0f * zoom), (int)(30.0f * zoom), 90, -180);
                        innerCircle = new Point(mitte.x - (int)(15.0f * zoom), mitte.y - (int)(10.0f * zoom));
                    }
                    g2.drawOval(innerCircle.x, innerCircle.y, (int)(20.0f * zoom), (int)(20.0f * zoom));
                    g2.setTransform(at);
                } else if (this.middleArrow.startsWith("delegation")) {
                    px1 = this.getLinePoints().elementAt(i3);
                    px2 = this.getLinePoints().elementAt(i3 + 1);
                    mitte = new Point(px1.x - (px1.x - px2.x) / 2, px1.y - (px1.y - px2.y) / 2);
                    at = g2.getTransform();
                    at2 = (AffineTransform)at.clone();
                    cx = mitte.x;
                    cy = mitte.y;
                    winkel = Utils.getAngle(px1.x, px1.y, px2.x, px2.y);
                    at2.rotate(winkel, cx, cy);
                    g2.setTransform(at2);
                    Point circle = new Point(mitte.x - (int)(15.0f * zoom), mitte.y - (int)(15.0f * zoom));
                    if (this.middleArrow.equals("delegation")) {
                        g2.setColor(Color.white);
                        g2.fillOval(circle.x + (int)(5.0f * zoom), circle.y + (int)(5.0f * zoom), (int)(20.0f * zoom), (int)(20.0f * zoom));
                        g2.setColor(this.fgColor);
                        g2.setStroke(Utils.getStroke(LineType.SOLID, 1.0f));
                        g2.drawOval(circle.x + (int)(5.0f * zoom), circle.y + (int)(5.0f * zoom), (int)(20.0f * zoom), (int)(20.0f * zoom));
                    }
                    if (this.middleArrow.startsWith("delegationArrow")) {
                        g2.setStroke(Utils.getStroke(LineType.SOLID, 1.0f));
                        if (this.middleArrow.equals("delegationArrowRight")) {
                            g2.drawLine(circle.x + (int)(5.0f * zoom), circle.y + (int)(15.0f * zoom), circle.x - (int)(5.0f * zoom), circle.y + (int)(9.0f * zoom));
                            g2.drawLine(circle.x + (int)(5.0f * zoom), circle.y + (int)(15.0f * zoom), circle.x - (int)(5.0f * zoom), circle.y + (int)(20.0f * zoom));
                        }
                        if (this.middleArrow.equals("delegationArrowLeft")) {
                            g2.drawLine(circle.x + (int)(25.0f * zoom), circle.y + (int)(15.0f * zoom), circle.x + (int)(35.0f * zoom), circle.y + (int)(9.0f * zoom));
                            g2.drawLine(circle.x + (int)(25.0f * zoom), circle.y + (int)(15.0f * zoom), circle.x + (int)(35.0f * zoom), circle.y + (int)(20.0f * zoom));
                        }
                        g2.setColor(Color.white);
                        g2.fillOval(circle.x + (int)(5.0f * zoom), circle.y + (int)(5.0f * zoom), (int)(20.0f * zoom), (int)(20.0f * zoom));
                        g2.setColor(this.fgColor);
                        g2.setStroke(Utils.getStroke(LineType.SOLID, 1.0f));
                        g2.drawOval(circle.x + (int)(5.0f * zoom), circle.y + (int)(5.0f * zoom), (int)(20.0f * zoom), (int)(20.0f * zoom));
                    }
                    if (this.middleArrow.equals("delegationStart")) {
                        g2.setColor(Color.white);
                        g2.fillArc(circle.x, circle.y, (int)(30.0f * zoom), (int)(30.0f * zoom), 90, 180);
                        g2.setColor(this.fgColor);
                        g2.setStroke(Utils.getStroke(LineType.SOLID, 1.0f));
                        g2.drawArc(circle.x, circle.y, (int)(30.0f * zoom), (int)(30.0f * zoom), 90, 180);
                    }
                    if (this.middleArrow.equals("delegationEnd")) {
                        g2.setColor(Color.white);
                        g2.fillArc(circle.x, circle.y, (int)(30.0f * zoom), (int)(30.0f * zoom), 90, -180);
                        g2.setColor(this.fgColor);
                        g2.setStroke(Utils.getStroke(LineType.SOLID, 1.0f));
                        g2.drawArc(circle.x, circle.y, (int)(30.0f * zoom), (int)(30.0f * zoom), 90, -180);
                    }
                    g2.setTransform(at);
                }
                if (this.lineType.equals("-.")) {
                    g2.setStroke(Utils.getStroke(LineType.DASHED, 1.0f));
                }
                if (!this.lineType.equals(".-")) continue;
                g2.setStroke(Utils.getStroke(LineType.SOLID, 1.0f));
                continue;
            }
            p1 = this.getLinePoints().elementAt(i3);
            p2 = this.getLinePoints().elementAt(i3 + 1);
            g2.drawLine(p1.x, p1.y, p2.x, p2.y);
        }
        g2.setStroke(Utils.getStroke(LineType.SOLID, 1.0f));
        if (HandlerElementMap.getHandlerForElement(this).getDrawPanel().getSelector().isSelected(this)) {
            for (i3 = 0; i3 < this.getLinePoints().size(); ++i3) {
                Point p = this.getLinePoints().elementAt(i3);
                int start = (int)(10.0f * zoom);
                int width = (int)(20.0f * zoom);
                g2.drawOval(p.x - start, p.y - start, width, width);
            }
            Polygon poly = this.getWholeLinePolygon();
            if (poly != null) {
                g2.drawPolygon(poly);
            }
        }
        Vector<Rectangle> tmp = new Vector<Rectangle>(startShapes);
        tmp.addAll(endShapes);
        for (int i4 = 0; i4 < tmp.size(); ++i4) {
            Rectangle r2 = tmp.elementAt(i4);
            if (r2 instanceof Qualifier) {
                Qualifier q2 = (Qualifier)r2;
                g.setColor(this.bgColor);
                g.fillRect(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
                g.setColor(this.fgColor);
                g.drawRect(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
                HandlerElementMap.getHandlerForElement(this).getFontHandler().writeText(g2, q2.getString(), (double)(r2.getX() + (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize()), (double)(r2.getY() + (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize()), AlignHorizontal.LEFT);
                continue;
            }
            if (r2 instanceof Arrow) {
                double winkel;
                int cy;
                int cx;
                AffineTransform at2;
                AffineTransform at;
                int[] tmpY;
                int[] tmpX;
                Arrow arrow = (Arrow)r2;
                if (arrow.getString().equals("crowsFoot")) {
                    g2.drawLine(arrow.getX(), arrow.getY() + arrow.getArrowEndA().y, arrow.getX() + arrow.getArrowEndA().x, arrow.getY());
                    g2.drawLine(arrow.getX(), arrow.getY() + arrow.getArrowEndB().y, arrow.getX() + arrow.getArrowEndB().x, arrow.getY());
                } else if (!(arrow.getString().equals("n") || arrow.getString().equals("require") || arrow.getString().equals("provide") || arrow.getString().startsWith("package") || arrow.getString().startsWith("comp"))) {
                    g2.drawLine(arrow.getX(), arrow.getY(), arrow.getX() + arrow.getArrowEndA().x, arrow.getY() + arrow.getArrowEndA().y);
                    g2.drawLine(arrow.getX(), arrow.getY(), arrow.getX() + arrow.getArrowEndB().x, arrow.getY() + arrow.getArrowEndB().y);
                }
                if (arrow.getString().equals("<<<")) {
                    int[] ax = new int[3];
                    int[] ay = new int[3];
                    ax[0] = arrow.getX();
                    ax[1] = arrow.getX() + arrow.getArrowEndA().x;
                    ax[2] = arrow.getX() + arrow.getArrowEndB().x;
                    ay[0] = arrow.getY();
                    ay[1] = arrow.getY() + arrow.getArrowEndA().y;
                    ay[2] = arrow.getY() + arrow.getArrowEndB().y;
                    Polygon myPg = new Polygon(ax, ay, 3);
                    g2.fill(myPg);
                    g2.draw(myPg);
                    continue;
                }
                if (arrow.getString().equals("<<")) {
                    int[] ax = new int[3];
                    int[] ay = new int[3];
                    ax[0] = arrow.getX();
                    ax[1] = arrow.getX() + arrow.getArrowEndA().x;
                    ax[2] = arrow.getX() + arrow.getArrowEndB().x;
                    ay[0] = arrow.getY();
                    ay[1] = arrow.getY() + arrow.getArrowEndA().y;
                    ay[2] = arrow.getY() + arrow.getArrowEndB().y;
                    Polygon myPg = new Polygon(ax, ay, 3);
                    g2.setColor(this.bgColor);
                    g2.fill(myPg);
                    g2.setColor(this.fgColor);
                    g2.draw(myPg);
                    continue;
                }
                if (arrow.getString().equals("x")) {
                    int[] ax = new int[4];
                    int[] ay = new int[4];
                    ax[0] = arrow.getX();
                    ay[0] = arrow.getY();
                    ax[1] = arrow.getX() + arrow.getArrowEndA().x;
                    ay[1] = arrow.getY() + arrow.getArrowEndA().y;
                    ax[3] = arrow.getX() + arrow.getArrowEndB().x;
                    ay[3] = arrow.getY() + arrow.getArrowEndB().y;
                    ax[2] = -arrow.getX() + ax[1] + ax[3];
                    ay[2] = -arrow.getY() + ay[1] + ay[3];
                    Polygon myPg = new Polygon(ax, ay, 4);
                    g2.setColor(this.bgColor);
                    g2.fill(myPg);
                    g2.setColor(this.fgColor);
                    g2.draw(myPg);
                    continue;
                }
                if (arrow.getString().equals("X")) {
                    int[] ax = new int[4];
                    int[] ay = new int[4];
                    ax[0] = arrow.getX();
                    ay[0] = arrow.getY();
                    ax[1] = arrow.getX() + arrow.getArrowEndA().x;
                    ay[1] = arrow.getY() + arrow.getArrowEndA().y;
                    ax[3] = arrow.getX() + arrow.getArrowEndB().x;
                    ay[3] = arrow.getY() + arrow.getArrowEndB().y;
                    ax[2] = -arrow.getX() + ax[1] + ax[3];
                    ay[2] = -arrow.getY() + ay[1] + ay[3];
                    g2.fill(new Polygon(ax, ay, 4));
                    continue;
                }
                if (arrow.getString().equals("n")) {
                    Point a1 = arrow.getCrossEndA();
                    Point a22 = arrow.getCrossEndB();
                    g2.drawLine(arrow.getX() + arrow.getArrowEndA().x, arrow.getY() + arrow.getArrowEndA().y, arrow.getX() + a22.x, arrow.getY() + a22.y);
                    g2.drawLine(arrow.getX() + arrow.getArrowEndB().x, arrow.getY() + arrow.getArrowEndB().y, arrow.getX() + a1.x, arrow.getY() + a1.y);
                    continue;
                }
                if (arrow.getString().equals("require")) {
                    int width = arrow.getCrossEndB().x - arrow.getCrossEndA().x;
                    int height = arrow.getCrossEndB().y - arrow.getCrossEndA().y;
                    g2.drawOval(arrow.getX() + arrow.getCrossEndA().x, arrow.getY() + arrow.getCrossEndA().y, width, height);
                    continue;
                }
                if (arrow.getString().equals("provide")) {
                    int width = arrow.getCrossEndB().x - arrow.getCrossEndA().x;
                    int height = arrow.getCrossEndB().y - arrow.getCrossEndA().y;
                    g2.drawArc(arrow.getX() + arrow.getCrossEndA().x, arrow.getY() + arrow.getCrossEndA().y, width, height, arrow.getArcStart(), arrow.getArcEnd());
                    continue;
                }
                if (arrow.getString().startsWith("package")) {
                    Point px2;
                    Point px1;
                    if (arrow.getString().equals("packageStart")) {
                        px1 = this.getStartPoint();
                        px2 = this.getLinePoints().elementAt(1);
                    } else {
                        px1 = this.getEndPoint();
                        px2 = this.getLinePoints().elementAt(this.getLinePoints().size() - 2);
                    }
                    AffineTransform at4 = g2.getTransform();
                    AffineTransform at23 = (AffineTransform)at4.clone();
                    int cx3 = px1.x;
                    int cy3 = px1.y;
                    double winkel3 = Utils.getAngle(px1.x, px1.y, px2.x, px2.y);
                    at23.rotate(winkel3, cx3, cy3);
                    g2.setTransform(at23);
                    g2.setColor(this.bgColor);
                    g2.fillOval(px1.x, px1.y - (int)(10.0f * zoom), (int)(20.0f * zoom), (int)(20.0f * zoom));
                    g2.setColor(this.fgColor);
                    g2.drawOval(px1.x, px1.y - (int)(10.0f * zoom), (int)(20.0f * zoom), (int)(20.0f * zoom));
                    g2.drawLine(px1.x + (int)(10.0f * zoom), px1.y - (int)(5.0f * zoom), px1.x + (int)(10.0f * zoom), px1.y + (int)(5.0f * zoom));
                    g2.drawLine(px1.x + (int)(15.0f * zoom), px1.y, px1.x + (int)(5.0f * zoom), px1.y);
                    g2.setTransform(at4);
                    continue;
                }
                if (arrow.getString().startsWith("fill_poly")) {
                    if (this.beginArrow.startsWith("fill_poly_start")) {
                        Point px1 = this.getStartPoint();
                        Point px2 = this.getLinePoints().elementAt(1);
                        AffineTransform at5 = g2.getTransform();
                        AffineTransform at24 = (AffineTransform)at5.clone();
                        double winkel4 = Utils.getAngle(px1.x, px1.y, px2.x, px2.y);
                        at24.rotate(winkel4, px1.x, px1.y);
                        g2.setTransform(at24);
                        int[] x_cord = new int[]{px1.x, px1.x + (int)(13.0f * zoom), px1.x + (int)(13.0f * zoom)};
                        int[] y_cord = new int[]{px1.y, px1.y - (int)(7.0f * zoom), px1.y + (int)(7.0f * zoom)};
                        Polygon x = new Polygon(x_cord, y_cord, 3);
                        g2.fillPolygon(x);
                        g2.setTransform(at5);
                    }
                    if (!this.endArrow.startsWith("fill_poly_end")) continue;
                    Point px1 = this.getEndPoint();
                    Point px2 = this.getLinePoints().elementAt(this.getLinePoints().size() - 2);
                    AffineTransform at6 = g2.getTransform();
                    AffineTransform at25 = (AffineTransform)at6.clone();
                    double winkel5 = Utils.getAngle(px2.x, px2.y, px1.x, px1.y);
                    at25.rotate(winkel5, px1.x, px1.y);
                    g2.setTransform(at25);
                    int[] x_cord = new int[]{px1.x, px1.x - (int)(13.0f * zoom), px1.x - (int)(13.0f * zoom)};
                    int[] y_cord = new int[]{px1.y, px1.y - (int)(7.0f * zoom), px1.y + (int)(7.0f * zoom)};
                    Polygon x = new Polygon(x_cord, y_cord, 3);
                    g2.fillPolygon(x);
                    g2.setTransform(at6);
                    continue;
                }
                if (!arrow.getString().startsWith("comp")) continue;
                int boxSize = (int)(20.0f * zoom);
                int arrowOneSize = (int)(5.9 * (double)zoom);
                int arrowTwoSize = (int)(6.9 * (double)zoom);
                int arrowTwoSeparator = (int)(2.4 * (double)zoom);
                int arrowThreeSize = (int)(6.0f * zoom);
                int arrowThreeLength = (int)(12.0f * zoom);
                if (this.beginArrow.startsWith("compStart")) {
                    HandlerElementMap.getHandlerForElement(this).getFontHandler().setFontSize(10.0);
                    int s = boxSize;
                    if (!this.csdStartText.equals("")) {
                        s = (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getTextWidth(this.csdStartText);
                    }
                    if (s < boxSize) {
                        s = boxSize;
                    }
                    Point px1 = this.getStartPoint();
                    Point px2 = this.getLinePoints().elementAt(1);
                    g2.setColor(this.bgColor);
                    g2.fillRect(px1.x - s / 2, px1.y - s / 2, s, s);
                    g2.setColor(this.fgColor);
                    g2.drawRect(px1.x - s / 2, px1.y - s / 2, s, s);
                    if (this.csdStartText.equals(">")) {
                        tmpX = new int[]{px1.x - arrowOneSize, px1.x + arrowOneSize, px1.x - arrowOneSize};
                        tmpY = new int[]{px1.y - arrowOneSize, px1.y, px1.y + arrowOneSize};
                        g2.fillPolygon(tmpX, tmpY, 3);
                    } else if (this.csdStartText.equals("<")) {
                        tmpX = new int[]{px1.x + arrowOneSize, px1.x - arrowOneSize, px1.x + arrowOneSize};
                        tmpY = new int[]{px1.y - arrowOneSize, px1.y, px1.y + arrowOneSize};
                        g2.fillPolygon(tmpX, tmpY, 3);
                    } else if (this.csdStartText.equals("v")) {
                        tmpX = new int[]{px1.x - arrowOneSize, px1.x, px1.x + arrowOneSize};
                        tmpY = new int[]{px1.y - arrowOneSize, px1.y + arrowOneSize, px1.y - arrowOneSize};
                        g2.fillPolygon(tmpX, tmpY, 3);
                    } else if (this.csdStartText.equals("^")) {
                        tmpX = new int[]{px1.x - arrowOneSize, px1.x, px1.x + arrowOneSize};
                        tmpY = new int[]{px1.y + arrowOneSize, px1.y - arrowOneSize, px1.y + arrowOneSize};
                        g2.fillPolygon(tmpX, tmpY, 3);
                    } else if (this.csdStartText.equals("=")) {
                        g2.drawLine(px1.x - arrowTwoSize, px1.y - arrowTwoSeparator, px1.x + arrowTwoSize, px1.y - arrowTwoSeparator);
                        g2.drawLine(px1.x + arrowTwoSize, px1.y - arrowTwoSeparator, px1.x + 1, px1.y - arrowTwoSize);
                        g2.drawLine(px1.x - arrowTwoSize, px1.y + arrowTwoSeparator, px1.x + arrowTwoSize, px1.y + arrowTwoSeparator);
                        g2.drawLine(px1.x - arrowTwoSize, px1.y + arrowTwoSeparator, px1.x - 1, px1.y + arrowTwoSize);
                    } else if (!this.csdStartText.equals("")) {
                        HandlerElementMap.getHandlerForElement(this).getFontHandler().writeText(g2, this.csdStartText, (double)px1.x, (double)(px1.y + (int)(6.0f * zoom)), AlignHorizontal.CENTER);
                    }
                    if (this.beginArrow.equals("compStartdel")) {
                        at = g2.getTransform();
                        at2 = (AffineTransform)at.clone();
                        cx = px1.x;
                        cy = px1.y;
                        winkel = Utils.getAngle(px1.x, px1.y, px2.x, px2.y);
                        at2.rotate(winkel, cx, cy);
                        g2.setTransform(at2);
                        g2.drawLine((int)((float)(px1.x + s / 2) + 2.0f * zoom), px1.y, px1.x + s / 2 + arrowThreeLength, px1.y - arrowThreeSize);
                        g2.drawLine((int)((float)(px1.x + s / 2) + 2.0f * zoom), px1.y, px1.x + s / 2 + arrowThreeLength, px1.y + arrowThreeSize);
                        g2.setTransform(at);
                    }
                    HandlerElementMap.getHandlerForElement(this).getFontHandler().resetFontSize();
                }
                if (!this.endArrow.startsWith("compEnd")) continue;
                HandlerElementMap.getHandlerForElement(this).getFontHandler().setFontSize(10.0);
                int s = boxSize;
                if (!this.csdEndText.equals("")) {
                    s = (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getTextWidth(this.csdEndText);
                }
                if (s < boxSize) {
                    s = boxSize;
                }
                Point px1 = this.getEndPoint();
                Point px2 = this.getLinePoints().elementAt(this.getLinePoints().size() - 2);
                g2.setColor(this.bgColor);
                g2.fillRect(px1.x - s / 2, px1.y - s / 2, s, s);
                g2.setColor(this.fgColor);
                g2.drawRect(px1.x - s / 2, px1.y - s / 2, s, s);
                if (this.csdEndText.equals(">")) {
                    tmpX = new int[]{px1.x - arrowOneSize, px1.x + arrowOneSize, px1.x - arrowOneSize};
                    tmpY = new int[]{px1.y - arrowOneSize, px1.y, px1.y + arrowOneSize};
                    g2.fillPolygon(tmpX, tmpY, 3);
                } else if (this.csdEndText.equals("<")) {
                    tmpX = new int[]{px1.x + arrowOneSize, px1.x - arrowOneSize, px1.x + arrowOneSize};
                    tmpY = new int[]{px1.y - arrowOneSize, px1.y, px1.y + arrowOneSize};
                    g2.fillPolygon(tmpX, tmpY, 3);
                } else if (this.csdEndText.equals("v")) {
                    tmpX = new int[]{px1.x - arrowOneSize, px1.x, px1.x + arrowOneSize};
                    tmpY = new int[]{px1.y - arrowOneSize, px1.y + arrowOneSize, px1.y - arrowOneSize};
                    g2.fillPolygon(tmpX, tmpY, 3);
                } else if (this.csdEndText.equals("^")) {
                    tmpX = new int[]{px1.x - arrowOneSize, px1.x, px1.x + arrowOneSize};
                    tmpY = new int[]{px1.y + arrowOneSize, px1.y - arrowOneSize, px1.y + arrowOneSize};
                    g2.fillPolygon(tmpX, tmpY, 3);
                } else if (this.csdEndText.equals("=")) {
                    g2.drawLine(px1.x - arrowTwoSize, px1.y - arrowTwoSeparator, px1.x + arrowTwoSize, px1.y - arrowTwoSeparator);
                    g2.drawLine(px1.x + arrowTwoSize, px1.y - arrowTwoSeparator, px1.x + 1, px1.y - arrowTwoSize);
                    g2.drawLine(px1.x - arrowTwoSize, px1.y + arrowTwoSeparator, px1.x + arrowTwoSize, px1.y + arrowTwoSeparator);
                    g2.drawLine(px1.x - arrowTwoSize, px1.y + arrowTwoSeparator, px1.x - 1, px1.y + arrowTwoSize);
                } else if (!this.csdEndText.equals("")) {
                    HandlerElementMap.getHandlerForElement(this).getFontHandler().writeText(g2, this.csdEndText, (double)px1.x, (double)(px1.y + (int)(6.0f * zoom)), AlignHorizontal.CENTER);
                }
                if (this.endArrow.equals("compEnddel")) {
                    at = g2.getTransform();
                    at2 = (AffineTransform)at.clone();
                    cx = px1.x;
                    cy = px1.y;
                    winkel = Utils.getAngle(px1.x, px1.y, px2.x, px2.y);
                    at2.rotate(winkel, cx, cy);
                    g2.setTransform(at2);
                    g2.drawLine((int)((float)(px1.x + s / 2) + 2.0f * zoom), px1.y, px1.x + s / 2 + arrowThreeLength, px1.y - arrowThreeSize);
                    g2.drawLine((int)((float)(px1.x + s / 2) + 2.0f * zoom), px1.y, px1.x + s / 2 + arrowThreeLength, px1.y + arrowThreeSize);
                    g2.setTransform(at);
                }
                HandlerElementMap.getHandlerForElement(this).getFontHandler().resetFontSize();
                continue;
            }
            if (r2 instanceof Multiplicity) {
                Multiplicity m2 = (Multiplicity)r2;
                HandlerElementMap.getHandlerForElement(this).getFontHandler().writeText(g2, m2.getString(), (double)r2.getX(), (double)(r2.getY() + (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize() + 2 * (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getDistanceBetweenTexts()), AlignHorizontal.LEFT);
                continue;
            }
            if (r2 instanceof Role) {
                Role role = (Role)r2;
                String str = role.getString();
                int position = 0;
                int y = 4 * (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getDistanceBetweenTexts();
                while (position != -1) {
                    position = str.indexOf("\\\\");
                    if (position != -1) {
                        String s = str.substring(0, position);
                        HandlerElementMap.getHandlerForElement(this).getFontHandler().writeText(g2, s, (double)r2.getX(), (double)(r2.getY() + y), AlignHorizontal.LEFT);
                        y += (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize();
                        str = str.substring(position + 2, str.length());
                        continue;
                    }
                    HandlerElementMap.getHandlerForElement(this).getFontHandler().writeText(g2, str, (double)r2.getX(), (double)(r2.getY() + y), AlignHorizontal.LEFT);
                }
                continue;
            }
            if (!(r2 instanceof Port)) continue;
            Port p = (Port)r2;
            HandlerElementMap.getHandlerForElement(this).getFontHandler().writeText(g2, p.getString(), (double)r2.getX(), (double)r2.getY(), AlignHorizontal.LEFT);
        }
        if (this.getStrings() != null && this.getStrings().size() > 0) {
            Point start = this.getCenterOfLine();
            int yPos = start.y - (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getDistanceBetweenTexts();
            int xPos = start.x;
            for (int i5 = 0; i5 < this.getStrings().size(); ++i5) {
                String s = this.getStrings().elementAt(i5);
                if ((s.startsWith(">") || s.endsWith(">") || s.startsWith("<") || s.endsWith("<")) && (s.indexOf(">") == s.lastIndexOf(">") && s.indexOf(">") != -1 || s.indexOf("<") == s.lastIndexOf("<") && s.indexOf("<") != -1)) {
                    Polygon temp;
                    int startDrawX;
                    int fontWidth;
                    int fontHeight = g2.getFontMetrics(HandlerElementMap.getHandlerForElement(this).getFontHandler().getFont()).getHeight() - g2.getFontMetrics(HandlerElementMap.getHandlerForElement(this).getFontHandler().getFont()).getDescent() - g2.getFontMetrics(HandlerElementMap.getHandlerForElement(this).getFontHandler().getFont()).getLeading();
                    fontHeight = fontHeight / 3 * 2;
                    if (s.endsWith(">")) {
                        s = s.substring(0, s.length() - 1);
                        fontWidth = (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getTextWidth(s);
                        startDrawX = (xPos -= (fontHeight + 4) / 2) + fontWidth / 2 + 4;
                        temp = new Polygon();
                        temp.addPoint(startDrawX, yPos);
                        temp.addPoint(startDrawX, yPos - fontHeight);
                        temp.addPoint(startDrawX + fontHeight - 1, yPos - fontHeight / 2);
                        g2.fillPolygon(temp);
                    } else if (s.endsWith("<")) {
                        s = s.substring(0, s.length() - 1);
                        fontWidth = (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getTextWidth(s);
                        startDrawX = (xPos -= (fontHeight + 4) / 2) + fontWidth / 2 + 4;
                        temp = new Polygon();
                        temp.addPoint(startDrawX + fontHeight - 1, yPos);
                        temp.addPoint(startDrawX + fontHeight - 1, yPos - fontHeight);
                        temp.addPoint(startDrawX, yPos - fontHeight / 2);
                        g2.fillPolygon(temp);
                    } else if (s.startsWith(">")) {
                        s = s.substring(1, s.length());
                        fontWidth = (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getTextWidth(s);
                        startDrawX = (xPos += (fontHeight + 4) / 2) - fontWidth / 2 - 4;
                        temp = new Polygon();
                        temp.addPoint(startDrawX - fontHeight + 1, yPos);
                        temp.addPoint(startDrawX - fontHeight + 1, yPos - fontHeight);
                        temp.addPoint(startDrawX, yPos - fontHeight / 2);
                        g2.fillPolygon(temp);
                    } else if (s.startsWith("<")) {
                        s = s.substring(1, s.length());
                        fontWidth = (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getTextWidth(s);
                        startDrawX = (xPos += (fontHeight + 4) / 2) - fontWidth / 2 - 4;
                        temp = new Polygon();
                        temp.addPoint(startDrawX, yPos);
                        temp.addPoint(startDrawX, yPos - fontHeight);
                        temp.addPoint(startDrawX - fontHeight + 1, yPos - fontHeight / 2);
                        g2.fillPolygon(temp);
                    }
                }
                HandlerElementMap.getHandlerForElement(this).getFontHandler().writeText(g2, s, (double)xPos, (double)yPos, AlignHorizontal.CENTER);
                yPos += (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize();
                yPos = (int)((double)yPos + HandlerElementMap.getHandlerForElement(this).getFontHandler().getDistanceBetweenTexts());
            }
        }
        Vector<Point> criticalPoints = new Vector<Point>();
        for (i2 = 1; i2 < startShapes.size(); ++i2) {
            Rectangle r3 = startShapes.elementAt(i2);
            Point p1 = new Point(r3.getX() - (int)(2.0f * zoom), r3.getY() - (int)(2.0f * zoom));
            Point p2 = new Point(r3.getX() + r3.getWidth() + (int)(2.0f * zoom), r3.getY() + r3.getHeight() + (int)(2.0f * zoom));
            criticalPoints.add(p1);
            criticalPoints.add(p2);
        }
        for (i2 = 1; i2 < endShapes.size(); ++i2) {
            Rectangle r4 = endShapes.elementAt(i2);
            Point p1 = new Point(r4.getX() - (int)(2.0f * zoom), r4.getY() - (int)(2.0f * zoom));
            Point p2 = new Point(r4.getX() + r4.getWidth() + (int)(2.0f * zoom), r4.getY() + r4.getHeight() + (int)(2.0f * zoom));
            criticalPoints.add(p1);
            criticalPoints.add(p2);
        }
        if (this.getStrings() != null && this.getStrings().size() > 0) {
            Point start = this.getCenterOfLine();
            int yPos = start.y;
            int xPos = start.x;
            for (int i6 = 0; i6 < this.getStrings().size(); ++i6) {
                String s = this.getStrings().elementAt(i6);
                int width = (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getTextWidth(s);
                criticalPoints.add(new Point(xPos - width / 2 - (int)(20.0f * zoom), yPos - (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize() - (int)(20.0f * zoom)));
                criticalPoints.add(new Point(xPos + width / 2 + (int)(20.0f * zoom), yPos + (int)(20.0f * zoom)));
                yPos += (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize();
                yPos = (int)((double)yPos + HandlerElementMap.getHandlerForElement(this).getFontHandler().getDistanceBetweenTexts());
            }
        }
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        int maxx = Integer.MIN_VALUE;
        int maxy = Integer.MIN_VALUE;
        for (i = 0; i < this.getLinePoints().size(); ++i) {
            Point p = this.getLinePoints().elementAt(i);
            minx = Math.min(minx, p.x);
            miny = Math.min(miny, p.y);
            maxx = Math.max(maxx, p.x);
            maxy = Math.max(maxy, p.y);
            minx = (int)Math.min((float)minx, (float)p.x - 15.0f * zoom);
            miny = (int)Math.min((float)miny, (float)p.y - 15.0f * zoom);
            maxx = (int)Math.max((float)maxx, (float)p.x + 15.0f * zoom);
            maxy = (int)Math.max((float)maxy, (float)p.y + 15.0f * zoom);
        }
        for (i = 0; i < criticalPoints.size(); ++i) {
            Point p = (Point)criticalPoints.elementAt(i);
            minx = Math.min(minx, p.x);
            miny = Math.min(miny, p.y);
            maxx = Math.max(maxx, p.x);
            maxy = Math.max(maxy, p.y);
        }
        int gridSize = HandlerElementMap.getHandlerForElement(this).getGridSize();
        minx -= minx % gridSize;
        miny -= miny % gridSize;
        minx -= gridSize;
        miny -= gridSize;
        maxx += maxx % gridSize;
        maxy += maxy % gridSize;
        if (maxx != 0 || maxy != 0) {
            int diffx = maxx - this.getRectangle().width;
            int diffy = maxy - this.getRectangle().height;
            this.setSize(this.getRectangle().width + diffx, this.getRectangle().height + diffy);
        }
        if (minx != 0 | miny != 0) {
            this.setLocationDifference(minx, miny);
            this.setSize(this.getRectangle().width + -minx, this.getRectangle().height + -miny);
            for (int i7 = 0; i7 < this.getLinePoints().size(); ++i7) {
                Point p = this.getLinePoints().elementAt(i7);
                p.x += -minx;
                p.y += -miny;
            }
        }
    }

    private Point getStartPoint() {
        Point ret = this.getLinePoints().elementAt(0);
        return ret;
    }

    private Point getEndPoint() {
        Point ret = this.getLinePoints().elementAt(this.getLinePoints().size() - 1);
        return ret;
    }

    public PointDouble getAbsoluteCoorStart() {
        PointDouble ret = new PointDouble((double)(this.getRectangle().x + this.getStartPoint().x), (double)(this.getRectangle().y + this.getStartPoint().y));
        return ret;
    }

    public PointDouble getAbsoluteCoorEnd() {
        PointDouble ret = new PointDouble((double)(this.getRectangle().x + this.getEndPoint().x), (double)(this.getRectangle().y + this.getEndPoint().y));
        return ret;
    }

    public String[] getCSDText(String str) {
        String[] tmp = new String[4];
        int to = 0;
        int from = 0;
        tmp[0] = " ";
        tmp[1] = " ";
        tmp[2] = " ";
        tmp[3] = " ";
        if (str.length() > 3) {
            from = str.indexOf("<[") + 2;
            if (from >= 2) {
                to = str.indexOf("]");
            }
            if (from >= 2 && to >= 0 && from < to) {
                tmp[0] = str.substring(from, to);
            }
            if ((from = str.indexOf("[", to) + 1) >= 1) {
                to = str.indexOf("]>", to);
            }
            if (from >= 1 && to >= 0 && from < to) {
                tmp[1] = str.substring(from, to);
            }
        }
        return tmp;
    }

    @Override
    public StickingPolygon generateStickingBorder() {
        return NoStickingPolygonGenerator.INSTANCE.generateStickingBorder(this.getRectangle());
    }

    @Override
    public StickingPolygon generateStickingBorder(int x, int y, int width, int height) {
        return NoStickingPolygonGenerator.INSTANCE.generateStickingBorder(this.getRectangle());
    }

    public boolean allPointsOnSamePos() {
        Point first = null;
        for (Point p : this.getLinePoints()) {
            if (first == null) {
                first = p;
                continue;
            }
            if (first.x == p.x && first.y == p.y) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Color getDefaultBackgroundColor() {
        return Converter.convert(ThemeFactory.getCurrentTheme().getColor(Theme.PredefinedColors.WHITE));
    }

    @Override
    public Set<Direction> getResizeArea(int x, int y) {
        return Collections.emptySet();
    }

    @Override
    public Integer getLayer() {
        return this.getLayerHelper(LayerFacet.DEFAULT_VALUE_RELATION);
    }
}

