/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui;

import com.baselet.control.config.Config;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.Notifier;
import java.util.HashMap;
import java.util.Map;

public class ExportHandler {
    private static final String DEFAULT_EXPORT_EXTENSION = "pdf";
    private Map<DiagramHandler, String> lastExportedFilePathsPerTab = new HashMap<DiagramHandler, String>();
    private static ExportHandler instance;

    public static ExportHandler getInstance() {
        if (instance == null) {
            instance = new ExportHandler();
        }
        return instance;
    }

    private ExportHandler() {
    }

    public void diagramTabIsClosed() {
        this.lastExportedFilePathsPerTab.remove(this.currentDiagramHandler());
    }

    private boolean currentDiagramHasBeenExported() {
        return this.lastExportedFilePathsPerTab.containsKey(this.currentDiagramHandler());
    }

    private String getLastExportFilePath() {
        return this.lastExportedFilePathsPerTab.get(this.currentDiagramHandler());
    }

    public void setExportedFilePath(String exportedFilePath) {
        this.lastExportedFilePathsPerTab.put(this.currentDiagramHandler(), exportedFilePath);
    }

    private DiagramHandler currentDiagramHandler() {
        return CurrentDiagram.getInstance().getDiagramHandler();
    }

    public void export() {
        String exportExtension;
        String exportFilePathWithoutExtension;
        if (this.currentDiagramHasBeenExported()) {
            String lastExportFilePath = this.getLastExportFilePath();
            exportFilePathWithoutExtension = this.filePathWithoutExtension(lastExportFilePath);
            exportExtension = this.extension(lastExportFilePath);
        } else {
            exportFilePathWithoutExtension = null;
            exportExtension = this.determineDefaultExportExtension();
        }
        String exportedFilePath = this.currentDiagramHandler().doSaveAs(exportFilePathWithoutExtension, exportExtension);
        if (exportedFilePath != null && !exportedFilePath.isEmpty()) {
            this.setExportedFilePath(exportedFilePath);
            String extension = this.extension(exportedFilePath);
            if (!extension.isEmpty()) {
                Config.getInstance().setLastExportFormat(extension);
            }
            Notifier.getInstance().showInfo("Diagram exported to " + exportedFilePath);
        }
    }

    private String determineDefaultExportExtension() {
        String configuredExportFormat = Config.getInstance().getLastExportFormat();
        if (configuredExportFormat.isEmpty()) {
            return DEFAULT_EXPORT_EXTENSION;
        }
        return configuredExportFormat;
    }

    private String filePathWithoutExtension(String filePath) {
        int extensionPos = filePath.lastIndexOf(".");
        if (extensionPos > 0) {
            return filePath.substring(0, extensionPos);
        }
        return filePath;
    }

    private String extension(String filePath) {
        int extensionPos = filePath.lastIndexOf(".");
        if (extensionPos > 0) {
            return filePath.substring(extensionPos + 1);
        }
        return "";
    }
}

