/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.command;

import com.baselet.control.basics.geom.Rectangle;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.DrawPanel;
import com.baselet.element.interfaces.GridElement;
import com.baselet.gui.command.Command;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Align
extends Command {
    private Point origin;
    private GridElement dominantEntity;
    private List<GridElement> entities;
    private Map<GridElement, Point> orgLocations = new HashMap<GridElement, Point>();
    private Edge edge;

    public Align(List<GridElement> entities, GridElement dominantEntity, String edge) {
        this.dominantEntity = dominantEntity;
        this.entities = new ArrayList<GridElement>(entities);
        this.edge = Edge.valueOf(edge.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public void execute(DiagramHandler handler) {
        super.execute(handler);
        if (this.entities.size() == 0 || this.dominantEntity == null) {
            return;
        }
        int oldZoom = handler.getGridSize();
        handler.setGridAndZoom(10, false);
        GridElement entity = this.dominantEntity;
        int left = entity.getRectangle().x;
        int right = left + entity.getRectangle().width;
        int top = entity.getRectangle().y;
        int bottom = top + entity.getRectangle().height;
        DrawPanel p = handler.getDrawPanel();
        for (GridElement e : this.entities) {
            Rectangle rectangle = e.getRectangle();
            int x = rectangle.x;
            int y = rectangle.y;
            switch (this.edge) {
                case LEFT: {
                    x = left;
                    break;
                }
                case RIGHT: {
                    x = right - e.getRectangle().width;
                    break;
                }
                case TOP: {
                    y = top;
                    break;
                }
                case BOTTOM: {
                    y = bottom - e.getRectangle().height;
                }
            }
            this.orgLocations.put(e, new Point(rectangle.x, rectangle.y));
            e.setLocation(handler.realignToGrid(true, x), handler.realignToGrid(true, y));
        }
        handler.setGridAndZoom(oldZoom, false);
        this.origin = handler.getDrawPanel().getOriginAtDefaultZoom();
        p.updatePanelAndScrollbars();
        p.repaint();
    }

    @Override
    public void undo(DiagramHandler handler) {
        super.undo(handler);
        int oldZoom = handler.getGridSize();
        handler.setGridAndZoom(10, false);
        int offsetX = this.origin.x - handler.getDrawPanel().getOrigin().x;
        int offsetY = this.origin.y - handler.getDrawPanel().getOrigin().y;
        for (GridElement entity : this.entities) {
            Point orgLocation = this.orgLocations.get(entity);
            entity.setLocation(handler.realignToGrid(true, orgLocation.x + offsetX), handler.realignToGrid(true, orgLocation.y + offsetY));
        }
        handler.setGridAndZoom(oldZoom, false);
        handler.getDrawPanel().updatePanelAndScrollbars();
        handler.getDrawPanel().repaint();
    }

    private static enum Edge {
        RIGHT,
        LEFT,
        TOP,
        BOTTOM;

    }
}

