/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.listener;

import com.baselet.control.basics.geom.Point;
import com.baselet.control.config.SharedConfig;
import com.baselet.control.enums.Direction;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramHandler;
import com.baselet.element.interfaces.GridElement;
import com.baselet.gui.CurrentGui;
import com.baselet.gui.command.Command;
import com.baselet.gui.command.Macro;
import com.baselet.gui.listener.GridElementListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class GUIListener
implements KeyListener {
    @Override
    public void keyPressed(KeyEvent e) {
        DiagramHandler handler;
        if (e.getKeyCode() == 16) {
            SharedConfig.getInstance().setStickingEnabled(false);
        }
        if ((handler = CurrentDiagram.getInstance().getDiagramHandler()) != null && !e.isAltDown() && !e.isAltGraphDown()) {
            if (e.getKeyCode() == 10) {
                CurrentGui.getInstance().getGui().focusPropertyPane();
            } else if (e.getKeyChar() == '+' || e.getKeyCode() == 521) {
                int actualZoom = handler.getGridSize();
                handler.setGridAndZoom(actualZoom + 1);
            } else if (e.getKeyChar() == '-' || e.getKeyCode() == 45) {
                int actualZoom = handler.getGridSize();
                handler.setGridAndZoom(actualZoom - 1);
            } else {
                int diffx = 0;
                int diffy = 0;
                if (e.getKeyCode() == 40 || e.getKeyCode() == 225) {
                    diffy = handler.getGridSize();
                }
                if (e.getKeyCode() == 38 || e.getKeyCode() == 224) {
                    diffy = -handler.getGridSize();
                }
                if (e.getKeyCode() == 37 || e.getKeyCode() == 226) {
                    diffx = -handler.getGridSize();
                }
                if (e.getKeyCode() == 39 || e.getKeyCode() == 227) {
                    diffx = handler.getGridSize();
                }
                if (diffx != 0 || diffy != 0) {
                    List<GridElement> entitiesToBeMoved = handler.getDrawPanel().getSelector().getSelectedElements();
                    if (entitiesToBeMoved.isEmpty()) {
                        entitiesToBeMoved = handler.getDrawPanel().getGridElements();
                    }
                    if (entitiesToBeMoved.isEmpty()) {
                        return;
                    }
                    Point opos = this.getOriginalPos(diffx, diffy, (GridElement)entitiesToBeMoved.iterator().next());
                    Vector<Command> ALL_MOVE_COMMANDS = GridElementListener.calculateFirstMoveCommands(diffx, diffy, opos, entitiesToBeMoved, e.isShiftDown(), true, handler, Collections.<Direction>emptySet());
                    handler.getController().executeCommand(new Macro(ALL_MOVE_COMMANDS));
                    CurrentDiagram.getInstance().getDiagramHandler().getDrawPanel().updatePanelAndScrollbars();
                }
            }
        }
    }

    private Point getOriginalPos(int diffx, int diffy, GridElement ge) {
        return new Point(ge.getRectangle().x - diffx, ge.getRectangle().y - diffy);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 16) {
            SharedConfig.getInstance().setStickingEnabled(true);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

