/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.plugin.refactoring;

import java.util.ArrayList;
import java.util.List;

public class JavaDocParser {
    private final String source;
    private int idx;
    private int sourceEnd;

    public JavaDocParser(String source) {
        this(source, 0, source.length());
    }

    public JavaDocParser(String source, int sourceStart, int sourceEnd) {
        this.source = source;
        this.idx = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public JavaDocCommentNode comment() {
        JavaDocCommentNode result = new JavaDocCommentNode();
        while (!this.isEof()) {
            int start = this.idx;
            HtmlTagStartNode node = this.htmlTagStart();
            if (node != null) {
                result.children.add(node);
                continue;
            }
            this.idx = start;
            this.nextCp();
        }
        return result;
    }

    public HtmlTagStartNode htmlTagStart() {
        HtmlTagStartNode result = new HtmlTagStartNode();
        result.start = this.idx;
        if (!this.consume('<')) {
            return null;
        }
        result.tagName = this.ident();
        if (result.tagName == null) {
            return null;
        }
        this.optWhitespace();
        result.attrs = this.attrs();
        this.consume('/');
        if (!this.consume('>')) {
            return null;
        }
        result.end = this.idx;
        return result;
    }

    public List<HtmlTagAttr> attrs() {
        ArrayList<HtmlTagAttr> result = new ArrayList<HtmlTagAttr>();
        while (true) {
            int start = this.idx;
            SourceString key = this.ident();
            if (key == null) {
                this.idx = start;
                return result;
            }
            this.optWhitespace();
            if (!this.consume('=')) {
                this.idx = start;
                return result;
            }
            this.optWhitespace();
            if (!this.consume('\"')) {
                this.idx = start;
                return result;
            }
            int valueStart = this.idx;
            while (!this.isEof() && this.cp() != 34) {
                this.nextCp();
            }
            SourceString value = new SourceString(this.source, valueStart, this.idx);
            if (!this.consume('\"')) {
                this.idx = start;
                return result;
            }
            this.optWhitespace();
            result.add(new HtmlTagAttr(key, value, start, this.idx));
        }
    }

    public void optWhitespace() {
        while (!this.isEof() && (Character.isWhitespace(this.cp()) || this.cp() == 10 || this.cp() == 13)) {
            this.nextCp();
        }
    }

    public SourceString ident() {
        if (this.isEof() || !Character.isJavaIdentifierStart(this.cp())) {
            return null;
        }
        int start = this.idx;
        this.nextCp();
        while (!this.isEof() && Character.isJavaIdentifierPart(this.cp())) {
            this.nextCp();
        }
        return new SourceString(this.source, start, this.idx);
    }

    private boolean isEof() {
        return this.idx >= this.sourceEnd;
    }

    private void nextCp() {
        this.idx += Character.charCount(this.cp());
    }

    private int cp() {
        return this.source.codePointAt(this.idx);
    }

    private boolean consume(char ch) {
        if (this.isEof()) {
            return false;
        }
        if (this.cp() != ch) {
            return false;
        }
        this.nextCp();
        return true;
    }

    public static class HtmlTagStartNode
    extends JavaDocNodeBase {
        public SourceString tagName;
        public List<HtmlTagAttr> attrs = new ArrayList<HtmlTagAttr>();
        public int start;
        public int end;

        public HtmlTagStartNode() {
        }

        public HtmlTagStartNode(SourceString tagName, int start, int end) {
            this.tagName = tagName;
            this.start = start;
            this.end = end;
        }

        public HtmlTagStartNode with(SourceString key, SourceString value, int start, int end) {
            this.attrs.add(new HtmlTagAttr(key, value, start, end));
            return this;
        }

        public String toString() {
            return "HtmlTagStartNode [tagName=" + this.tagName + ", attrs=" + this.attrs + ", start=" + this.start + ", end=" + this.end + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.attrs == null ? 0 : this.attrs.hashCode());
            result = 31 * result + this.end;
            result = 31 * result + this.start;
            result = 31 * result + (this.tagName == null ? 0 : this.tagName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof HtmlTagStartNode)) {
                return false;
            }
            HtmlTagStartNode other = (HtmlTagStartNode)obj;
            if (this.attrs == null ? other.attrs != null : !this.attrs.equals(other.attrs)) {
                return false;
            }
            if (this.end != other.end) {
                return false;
            }
            if (this.start != other.start) {
                return false;
            }
            return !(this.tagName == null ? other.tagName != null : !this.tagName.equals(other.tagName));
        }

        public HtmlTagAttr getAttr(String key) {
            for (HtmlTagAttr attr : this.attrs) {
                if (!attr.key.getValue().equals(key)) continue;
                return attr;
            }
            return null;
        }

        public boolean hasAttr(String key) {
            return this.getAttr(key) != null;
        }

        public int length() {
            return this.end - this.start;
        }
    }

    public static class SourceString {
        public String source;
        public int start;
        public int end;

        public SourceString(String source, int start, int end) {
            this.source = source;
            this.start = start;
            this.end = end;
        }

        public String getValue() {
            return this.source.substring(this.start, this.end);
        }

        public int length() {
            return this.end - this.start;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.end;
            result = 31 * result + this.start;
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SourceString)) {
                return false;
            }
            SourceString other = (SourceString)obj;
            if (this.end != other.end) {
                return false;
            }
            if (this.start != other.start) {
                return false;
            }
            return !(this.source == null ? other.source != null : !this.source.equals(other.source));
        }

        public String toString() {
            return "SourceString [value=" + this.getValue() + ", start=" + this.start + ", end=" + this.end + "]";
        }
    }

    public static class HtmlTagAttr {
        public SourceString key;
        public SourceString value;
        public int start;
        public int end;

        public HtmlTagAttr(SourceString key, SourceString value, int start, int end) {
            this.key = key;
            this.value = value;
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "HtmlTagAttr [key=" + this.key + ", value=" + this.value + ", start=" + this.start + ", end=" + this.end + "]";
        }

        public int length() {
            return this.end - this.start;
        }
    }

    public static class JavaDocCommentNode
    extends JavaDocNodeBase {
        public List<JavaDocNodeBase> children = new ArrayList<JavaDocNodeBase>();

        public <T extends JavaDocNodeBase> List<T> ofType(Class<T> clazz) {
            ArrayList<T> result = new ArrayList<T>();
            for (JavaDocNodeBase child : this.children) {
                if (!clazz.isInstance(child)) continue;
                result.add(clazz.cast(child));
            }
            return result;
        }
    }

    public static abstract class JavaDocNodeBase {
    }
}

