/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.basics;

import com.baselet.control.basics.Line1D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class SortedMergedLine1DList
implements List<Line1D> {
    private final List<Line1D> list = new ArrayList<Line1D>();

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<Line1D> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(Line1D e) {
        if (this.contains(e)) {
            return false;
        }
        ListIterator<Line1D> listIter = this.list.listIterator();
        while (listIter.hasNext()) {
            if (!(listIter.next().getHigh() >= e.getLow())) continue;
            listIter.previous();
            break;
        }
        if (!listIter.hasNext()) {
            this.list.add(e);
            return true;
        }
        int insertIndex = listIter.nextIndex();
        Line1D tmpLine = listIter.next();
        if (tmpLine.getLow() <= e.getHigh()) {
            double low = Math.min(tmpLine.getLow(), e.getLow());
            double high = tmpLine.getHigh();
            while (listIter.hasNext() && e.isIntersecting(tmpLine = listIter.next())) {
                listIter.remove();
                high = tmpLine.getHigh();
            }
            this.list.set(insertIndex, new Line1D(low, Math.max(e.getHigh(), high)));
        } else {
            this.list.add(insertIndex, e);
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Line1D> c) {
        boolean changed = false;
        for (Line1D line1D : c) {
            changed = this.add(line1D) || changed;
        }
        return changed;
    }

    public boolean addAll(Line1D[] c) {
        boolean changed = false;
        for (Line1D l : c) {
            changed = this.add(l) || changed;
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Line1D> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public Line1D get(int index) {
        return this.list.get(index);
    }

    @Override
    public Line1D set(int index, Line1D element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, Line1D element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Line1D remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<Line1D> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<Line1D> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<Line1D> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }
}

