/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.enums;

import com.baselet.control.enums.RegexValueHolder;
import com.baselet.diagram.draw.helper.StyleException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum LineType implements RegexValueHolder
{
    SOLID("-"),
    DASHED("."),
    DOTTED(".."),
    DOUBLE("="),
    DOUBLE_DASHED(":"),
    DOUBLE_DOTTED("::");

    private String value;
    public static final List<LineType> LT_LIST;

    private LineType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static LineType fromString(String text) {
        for (LineType lineType : LineType.values()) {
            if (!lineType.getValue().equalsIgnoreCase(text)) continue;
            return lineType;
        }
        throw new StyleException("Allowed values for LineType: -, ., .., =, :, ::");
    }

    public String getReadableText() {
        return this.name().toLowerCase();
    }

    @Override
    public String getRegexValue() {
        return this.value.replaceAll("\\.", "\\\\.");
    }

    static {
        LT_LIST = Collections.unmodifiableList(Arrays.asList(SOLID, DASHED, DOTTED));
    }
}

