/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.enums;

import com.baselet.control.enums.RuntimeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Program {
    private static final Logger log = LoggerFactory.getLogger(Program.class);
    private static Program instance;
    private final RuntimeType runtimeType;
    private final String configName;
    private final String programName;
    private final String extension;
    private final String website;
    private final String version;

    public static Program getInstance() {
        if (!Program.isInitialized()) {
            throw new RuntimeException("Program must be initialized before using it");
        }
        return instance;
    }

    public static void init(String version, RuntimeType runtimeType) {
        instance = new Program(version, runtimeType);
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    private Program(String version, RuntimeType runtimeType) {
        log.info("Initializing Program: Version=" + version + ", Runtime=" + (Object)((Object)runtimeType));
        this.version = version;
        this.runtimeType = runtimeType;
        this.programName = "UMLet";
        this.extension = "uxf";
        this.website = "http://www." + this.getProgramName().toLowerCase() + ".com";
        this.configName = runtimeType == RuntimeType.ECLIPSE_PLUGIN ? this.getProgramName().toLowerCase() + "plugin.cfg" : this.getProgramName().toLowerCase() + ".cfg";
    }

    public RuntimeType getRuntimeType() {
        return this.runtimeType;
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getProgramName() {
        return this.programName;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getWebsite() {
        return this.website;
    }

    public String getVersion() {
        return this.version;
    }
}

