/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram.draw;

import com.baselet.control.StringStyle;
import com.baselet.control.basics.geom.DimensionDouble;
import com.baselet.control.basics.geom.Line;
import com.baselet.control.basics.geom.Lines;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.FormatLabels;
import com.baselet.control.enums.LineType;
import com.baselet.diagram.draw.DrawFunction;
import com.baselet.diagram.draw.JavascriptCodeParser;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.diagram.draw.helper.Style;
import com.baselet.diagram.draw.helper.StyleException;
import com.baselet.diagram.draw.helper.theme.Theme;
import com.baselet.diagram.draw.helper.theme.ThemeFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public abstract class DrawHandler {
    protected static final double HALF_PX = 0.5;
    public JavascriptCodeParser javascriptCodeParser;
    protected Style style = new Style();
    private final Style overlay = new Style();
    private final ArrayList<DrawFunction> drawablesBackground = new ArrayList();
    private final ArrayList<DrawFunction> drawablesForeground = new ArrayList();
    private Layer layer = Layer.Background;
    private boolean enableDrawing = true;

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public void setEnableDrawing(boolean enableDrawing) {
        this.enableDrawing = enableDrawing;
    }

    protected Style getOverlay() {
        return this.overlay;
    }

    protected void addDrawable(DrawFunction drawable) {
        if (this.enableDrawing) {
            if (this.layer == Layer.Foreground) {
                this.drawablesForeground.add(drawable);
            } else {
                this.drawablesBackground.add(drawable);
            }
        }
    }

    public void drawAll(boolean isSelected) {
        if (isSelected) {
            this.overlay.setForegroundColor(ThemeFactory.getCurrentTheme().getColor(Theme.ColorStyle.SELECTION_FG));
        } else {
            this.overlay.setForegroundColor(null);
        }
        this.drawAll();
    }

    public void clearCache() {
        this.drawablesBackground.clear();
        this.drawablesForeground.clear();
    }

    public final double textHeightMaxWithSpace() {
        return this.textHeightMax() + this.getDistanceBetweenTextLines();
    }

    public final double textHeightMax() {
        return this.textDimension(new StringStyle(Collections.<FormatLabels>emptySet(), "Hy")).getHeight();
    }

    public final double textHeight(String singleLineWithMarkup) {
        return this.textHeight(this.escapeAndAnalyzeSingleLine(singleLineWithMarkup));
    }

    public final double textHeight(StringStyle singleLine) {
        return this.textDimension(singleLine).getHeight();
    }

    public final double textWidth(String singleLineWithMarkup) {
        return this.textWidth(this.escapeAndAnalyzeSingleLine(singleLineWithMarkup));
    }

    public final double textWidth(StringStyle singleLine) {
        return this.textDimension(singleLine).getWidth();
    }

    public final void setForegroundColor(String color) {
        if (color.equals("fg")) {
            this.setForegroundColor(ThemeFactory.getCurrentTheme().getColor(Theme.ColorStyle.DEFAULT_FOREGROUND));
        } else {
            this.setForegroundColor(ThemeFactory.getCurrentTheme().forString(color, ColorOwn.Transparency.FOREGROUND));
        }
    }

    public final void setForegroundColor(ColorOwn color) {
        if (color == null) {
            this.style.setForegroundColor(ThemeFactory.getCurrentTheme().getColor(Theme.ColorStyle.DEFAULT_FOREGROUND));
        } else {
            this.style.setForegroundColor(color);
        }
    }

    public final void setBackgroundColorAndKeepTransparency(String color) {
        if (color.equals("bg")) {
            this.setBackgroundColor(ThemeFactory.getCurrentTheme().getColor(Theme.ColorStyle.DEFAULT_BACKGROUND));
        } else {
            ColorOwn defaultBg;
            Theme currentTheme = ThemeFactory.getCurrentTheme();
            ColorOwn oldBg = this.getBackgroundColor();
            int newAlpha = oldBg == (defaultBg = currentTheme.getColor(Theme.ColorStyle.DEFAULT_BACKGROUND)) ? ColorOwn.Transparency.BACKGROUND.getAlpha() : oldBg.getAlpha();
            this.setBackgroundColor(currentTheme.forString(color, newAlpha));
        }
    }

    public final void setBackgroundColor(ColorOwn color) {
        if (color == null) {
            this.style.setBackgroundColor(ThemeFactory.getCurrentTheme().getColor(Theme.ColorStyle.DEFAULT_BACKGROUND));
        } else {
            this.style.setBackgroundColor(color);
        }
    }

    public final void setTransparency(double transparencyVal) {
        if (transparencyVal < 0.0 || transparencyVal > 100.0) {
            throw new StyleException("The transparency value must be between 0 and 100");
        }
        double colorTransparencyValue = 255.0 - transparencyVal * 2.55;
        ColorOwn bgColor = this.getBackgroundColor();
        this.setBackgroundColor(bgColor.transparency((int)colorTransparencyValue));
    }

    public ColorOwn getForegroundColor() {
        return this.style.getForegroundColor();
    }

    public ColorOwn getBackgroundColor() {
        return this.style.getBackgroundColor();
    }

    public double getLineWidth() {
        return this.style.getLineWidth();
    }

    public void resetColorSettings() {
        this.setForegroundColor("fg");
        this.setBackgroundColorAndKeepTransparency("bg");
    }

    public final void setFontSize(double fontSize) {
        this.assertDoubleRange(fontSize);
        this.style.setFontSize(fontSize);
    }

    public double getFontSize() {
        return this.style.getFontSize();
    }

    public final void setLineType(LineType type) {
        this.style.setLineType(type);
    }

    public final void setLineType(String lineTypeString) {
        LineType lineType = LineType.fromString(lineTypeString);
        this.style.setLineType(lineType);
    }

    public LineType getLineType() {
        return this.style.getLineType();
    }

    public final void setLineWidth(double lineWidth) {
        this.assertDoubleRange(lineWidth);
        this.style.setLineWidth(lineWidth);
    }

    private void assertDoubleRange(double doubleValue) {
        if (doubleValue < 0.0 || doubleValue > 5000.0) {
            throw new StyleException("value must be >=0 and <=5000");
        }
    }

    public void resetStyle() {
        this.resetColorSettings();
        this.style.setFontSize(this.getDefaultFontSize());
        this.style.setLineType(LineType.SOLID);
        this.style.setLineWidth(1.0);
    }

    public Style getStyleClone() {
        return this.style.cloneFromMe();
    }

    public void setStyle(Style style) {
        this.style = style.cloneFromMe();
    }

    public void drawAll() {
        for (DrawFunction d : this.drawablesBackground) {
            d.run();
        }
        for (DrawFunction d : this.drawablesForeground) {
            d.run();
        }
    }

    public double getDistanceBorderToText() {
        return 5.0;
    }

    public double getDistanceBetweenTextLines() {
        return 3.0;
    }

    protected DimensionDouble textDimension(StringStyle singleLine) {
        return this.textDimensionHelper(singleLine);
    }

    protected abstract DimensionDouble textDimensionHelper(StringStyle var1);

    protected abstract double getDefaultFontSize();

    public void drawRectangle(Rectangle rect) {
        this.drawRectangle(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public void drawLine(Line line) {
        this.drawLine(line.getStart().getX(), line.getStart().getY(), line.getEnd().getX(), line.getEnd().getY());
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.drawLines(new PointDouble(x1, y1), new PointDouble(x2, y2));
    }

    public void drawLines(Collection<PointDouble> points) {
        this.drawLines(points.toArray(new PointDouble[points.size()]));
    }

    public void drawLines(Line ... lines) {
        this.drawLines(Lines.toPoints(lines));
    }

    protected StringStyle escapeAndAnalyzeSingleLine(String singleLineWithMarkup) {
        return StringStyle.analyzeFormatLabels(StringStyle.replaceNotEscaped(singleLineWithMarkup));
    }

    public void print(String multiLineWithMarkup, double x, double y, AlignHorizontal align) {
        this.print(multiLineWithMarkup, new PointDouble(x, y), align);
    }

    public void print(StringStyle singleLine, double x, double y, AlignHorizontal align) {
        this.printHelper(new StringStyle[]{singleLine}, new PointDouble(x, y), align);
    }

    public void print(String multiLineWithMarkup, PointDouble point, AlignHorizontal align) {
        String[] lines = multiLineWithMarkup.split("\n");
        StringStyle[] formatedLines = new StringStyle[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            formatedLines[i] = this.escapeAndAnalyzeSingleLine(lines[i]);
        }
        this.printHelper(formatedLines, point, align);
    }

    public void print(String[] lines, Set<FormatLabels> format, PointDouble point, AlignHorizontal align) {
        StringStyle[] formatedLines = new StringStyle[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            formatedLines[i] = new StringStyle(format, lines[i]);
        }
        this.printHelper(formatedLines, point, align);
    }

    public abstract void drawArc(double var1, double var3, double var5, double var7, double var9, double var11, boolean var13);

    public void drawArc(double x, double y, double width, double height, double start, double extent, boolean open, String bgColor, String fgColor, String lineTypeString, Double lineWidth, Double transparency) {
        this.setExtraDrawValues(bgColor, fgColor, lineTypeString, lineWidth, transparency);
        this.drawArc(x, y, width, height, start, extent, open);
    }

    public abstract void drawCircle(double var1, double var3, double var5);

    public void drawCircle(double x, double y, double radius, String bgColor, String fgColor, String lineTypeString, Double lineWidth, Double transparency) {
        this.setExtraDrawValues(bgColor, fgColor, lineTypeString, lineWidth, transparency);
        this.drawCircle(x, y, radius);
    }

    public abstract void drawEllipse(double var1, double var3, double var5, double var7);

    public void drawEllipse(double x, double y, double width, double height, String bgColor, String fgColor, String lineTypeString, Double lineWidth, Double transparency) {
        this.setExtraDrawValues(bgColor, fgColor, lineTypeString, lineWidth, transparency);
        this.drawEllipse(x, y, width, height);
    }

    public abstract void drawLines(PointDouble ... var1);

    public abstract void drawRectangle(double var1, double var3, double var5, double var7);

    public void drawRectangle(double x, double y, double width, double height, String bgColor, String fgColor, String lineTypeString, Double lineWidth, Double transparency) {
        this.setExtraDrawValues(bgColor, fgColor, lineTypeString, lineWidth, transparency);
        this.drawRectangle(x, y, width, height);
    }

    public abstract void drawRectangleRound(double var1, double var3, double var5, double var7, double var9);

    public void drawRectangleRound(double x, double y, double width, double height, double radius, String bgColor, String fgColor, String lineTypeString, Double lineWidth, Double transparency) {
        this.setExtraDrawValues(bgColor, fgColor, lineTypeString, lineWidth, transparency);
        this.drawRectangleRound(x, y, width, height, radius);
    }

    public void drawLine(double x1, double y1, double x2, double y2, String fgColor, String lineTypeString, Double lineWidth) {
        if (lineWidth != null) {
            this.setLineWidth(lineWidth);
        }
        if (lineTypeString != null) {
            this.setLineType(lineTypeString);
        }
        if (fgColor != null) {
            this.setForegroundColor(fgColor);
        }
        this.drawLine(x1, y1, x2, y2);
    }

    public void print(String multiLineWithMarkup, double x, double y, AlignHorizontal align, String fgColor) {
        if (fgColor != null) {
            this.setForegroundColor(fgColor);
        }
        this.print(multiLineWithMarkup, x, y, align);
    }

    private void setExtraDrawValues(String bgColor, String fgColor, String lineTypeString, Double lineWidth, Double transparency) {
        if (lineWidth != null) {
            this.setLineWidth(lineWidth);
        }
        if (lineTypeString != null) {
            this.setLineType(lineTypeString);
        }
        if (fgColor != null) {
            this.setForegroundColor(fgColor);
        }
        if (bgColor != null) {
            this.setBackgroundColorAndKeepTransparency(bgColor);
        }
        if (transparency != null) {
            this.setTransparency(transparency);
        }
    }

    public abstract void printHelper(StringStyle[] var1, PointDouble var2, AlignHorizontal var3);

    public JavascriptCodeParser getJavascriptCodeParser() {
        return this.javascriptCodeParser;
    }

    public void setJavascriptCodeParser(JavascriptCodeParser javascriptCodeParser) {
        this.javascriptCodeParser = javascriptCodeParser;
    }

    public static enum Layer {
        Foreground,
        Background;

    }
}

