/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram.draw.helper;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorOwn {
    private static final Logger log = LoggerFactory.getLogger(ColorOwn.class);
    protected final int red;
    protected final int green;
    protected final int blue;
    protected final int alpha;

    public ColorOwn(int red, int green, int blue, Transparency transparency) {
        this(red, green, blue, transparency.getAlpha());
    }

    public ColorOwn(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public ColorOwn(String hex) {
        int i = Integer.decode(hex);
        this.red = i >> 16 & 0xFF;
        this.green = i >> 8 & 0xFF;
        this.blue = i & 0xFF;
        this.alpha = Transparency.FOREGROUND.getAlpha();
    }

    public ColorOwn() {
        this(0, 0, 0, 0);
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public ColorOwn transparency(Transparency transparency) {
        return this.transparency(transparency.getAlpha());
    }

    public ColorOwn transparency(int alpha) {
        return new ColorOwn(this.getRed(), this.getGreen(), this.getBlue(), alpha);
    }

    public ColorOwn darken(int factor) {
        return new ColorOwn(Math.max(0, this.getRed() - factor), Math.max(0, this.getGreen() - factor), Math.max(0, this.getBlue() - factor), this.getAlpha());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.alpha;
        result = 31 * result + this.blue;
        result = 31 * result + this.green;
        result = 31 * result + this.red;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorOwn other = (ColorOwn)obj;
        if (this.alpha != other.alpha) {
            return false;
        }
        if (this.blue != other.blue) {
            return false;
        }
        if (this.green != other.green) {
            return false;
        }
        return this.red == other.red;
    }

    public String toString() {
        return "ColorOwn [red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", alpha=" + this.alpha + "]";
    }

    public static enum Transparency {
        FOREGROUND(255),
        FULL_TRANSPARENT(0),
        DEPRECATED_WARNING(175),
        BACKGROUND(125),
        SELECTION_BACKGROUND(20);

        private int alpha;

        private Transparency(int alpha) {
            this.alpha = alpha;
        }

        public int getAlpha() {
            return this.alpha;
        }
    }
}

