/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram.draw.helper.theme;

import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.diagram.draw.helper.StyleException;
import java.util.Map;

public abstract class Theme {
    public static final String EXAMPLE_TEXT = "color string (green,...) or code (#3c7a00,...)";
    protected Map<PredefinedColors, ColorOwn> colorMap;
    protected Map<ColorStyle, ColorOwn> styleColorMap;

    public ColorOwn forStringOrNull(String colorString, ColorOwn.Transparency transparency) {
        try {
            return this.forString(colorString, transparency);
        }
        catch (StyleException e) {
            return null;
        }
    }

    public ColorOwn forString(String colorString, ColorOwn.Transparency transparency) {
        return this.forString(colorString, transparency.getAlpha());
    }

    public ColorOwn forString(String colorString, int transparency) {
        boolean error = false;
        ColorOwn returnColor = null;
        if (colorString == null) {
            error = true;
        } else {
            for (Map.Entry<PredefinedColors, ColorOwn> c : this.colorMap.entrySet()) {
                if (!colorString.equalsIgnoreCase(c.getKey().toString())) continue;
                returnColor = c.getValue();
                break;
            }
            if (returnColor == null) {
                try {
                    returnColor = new ColorOwn(colorString);
                }
                catch (NumberFormatException e) {
                    error = true;
                }
            }
            if (returnColor != null) {
                returnColor = returnColor.transparency(transparency);
            }
        }
        if (error) {
            throw new StyleException("value must be a color string (green,...) or code (#3c7a00,...)");
        }
        return returnColor;
    }

    public ColorOwn getColor(PredefinedColors color) {
        return this.colorMap.get((Object)color);
    }

    public ColorOwn getColor(ColorStyle colorStyle) {
        return this.styleColorMap.get((Object)colorStyle);
    }

    public Map<PredefinedColors, ColorOwn> getColorMap() {
        return this.colorMap;
    }

    public static enum ColorStyle {
        SELECTION_FG,
        SELECTION_BG,
        STICKING_POLYGON,
        SYNTAX_HIGHLIGHTING,
        DEFAULT_FOREGROUND,
        DEFAULT_BACKGROUND,
        DEFAULT_DOCUMENT_BACKGROUND,
        DEFAULT_SPLITTER_COLOR;

    }

    public static enum PredefinedColors {
        RED,
        GREEN,
        BLUE,
        YELLOW,
        MAGENTA,
        WHITE,
        BLACK,
        ORANGE,
        CYAN,
        DARK_GRAY,
        GRAY,
        LIGHT_GRAY,
        PINK,
        TRANSPARENT,
        NONE;

    }
}

