/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram.draw.helper.theme;

import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.diagram.draw.helper.theme.Theme;
import com.baselet.diagram.draw.helper.theme.ThemeChangeListener;
import com.baselet.diagram.draw.helper.theme.ThemeDark;
import com.baselet.diagram.draw.helper.theme.ThemeLight;
import java.util.ArrayList;
import java.util.List;

public class ThemeFactory {
    private static Theme theme;
    private static String lastBackgroundColor;
    private static THEMES activeThemeEnum;
    private static final List<ThemeChangeListener> listeners;

    public static void changeTheme(THEMES chosenTheme, String backgroundColor, boolean overrideBackground) {
        if (!chosenTheme.equals((Object)activeThemeEnum)) {
            switch (chosenTheme) {
                case DARK: {
                    activeThemeEnum = chosenTheme;
                    theme = new ThemeDark();
                    break;
                }
                case LIGHT: {
                    activeThemeEnum = chosenTheme;
                    theme = new ThemeLight();
                    break;
                }
                default: {
                    activeThemeEnum = THEMES.LIGHT;
                    theme = new ThemeLight();
                }
            }
        }
        if (backgroundColor != null) {
            lastBackgroundColor = backgroundColor;
        }
        if (lastBackgroundColor != null && overrideBackground) {
            ThemeFactory.theme.styleColorMap.put(Theme.ColorStyle.DEFAULT_DOCUMENT_BACKGROUND, new ColorOwn(lastBackgroundColor));
        }
        for (ThemeChangeListener listener : listeners) {
            listener.onThemeChange();
        }
    }

    public static Theme getCurrentTheme() {
        if (theme == null) {
            ThemeFactory.changeTheme(THEMES.LIGHT, null, true);
        }
        return theme;
    }

    public static THEMES getActiveThemeEnum() {
        return activeThemeEnum;
    }

    public static void addListener(ThemeChangeListener listener) {
        listeners.add(listener);
    }

    static {
        listeners = new ArrayList<ThemeChangeListener>();
    }

    public static enum THEMES {
        LIGHT,
        DARK;

    }
}

