/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element;

import com.baselet.control.basics.geom.DimensionDouble;
import com.baselet.control.enums.ElementStyle;
import com.baselet.element.NewGridElement;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.PropertiesParserState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PropertiesParser {
    public static void parsePropertiesAndHandleFacets(NewGridElement element, PropertiesParserState state) {
        List<String> propertiesText = element.getPanelAttributesAsList();
        PropertiesParser.doPreparsing(element, state, propertiesText);
        PropertiesParser.parseFacets(element, state, propertiesText, true);
    }

    private static void doPreparsing(NewGridElement element, PropertiesParserState state, List<String> propertiesText) {
        state.resetValues(element.getRealSize(), state.getTotalTextBlockHeight(), false);
        PropertiesParser.parseFacets(element, state, propertiesText, false);
        if (state.getElementStyle() == ElementStyle.AUTORESIZE) {
            double width = state.getMinimumWidth();
            double height = state.getTextPrintPosition();
            element.handleAutoresize(new DimensionDouble(width, height), state.getAlignment().getHorizontal());
        }
        double textblockHeight = state.getTextPrintPosition() - state.getBuffer().getTop();
        state.resetValues(element.getRealSize(), textblockHeight, true);
    }

    private static void parseFacets(NewGridElement element, PropertiesParserState state, List<String> propertiesText, boolean drawMetaDrawer) {
        List<String> propertiesAfterFirstRun = PropertiesParser.parseFacets(state.getSettings().getFacetsForFirstRun(), propertiesText, state);
        element.resetMetaDrawerAndDrawCommonContent(state, drawMetaDrawer);
        PropertiesParser.parseFacets(state.getSettings().getFacetsForSecondRun(), propertiesAfterFirstRun, state);
    }

    private static List<String> parseFacets(List<? extends Facet> facets, List<String> properties, PropertiesParserState state) {
        HashMap facetUsageMap = new HashMap();
        for (Facet facet : facets) {
            facetUsageMap.put(facet, new ArrayList());
        }
        ArrayList<String> unusedProperties = new ArrayList<String>(properties);
        Iterator iterator = unusedProperties.iterator();
        block1: while (iterator.hasNext()) {
            String string = (String)iterator.next();
            for (Facet facet : facets) {
                if (!facet.checkStart(string, state)) continue;
                facet.handleLine(string, state);
                ((List)facetUsageMap.get(facet)).add(string);
                iterator.remove();
                continue block1;
            }
        }
        for (Facet facet : facets) {
            facet.parsingFinished(state, (List)facetUsageMap.get(facet));
        }
        return unusedProperties;
    }
}

